/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cli;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.cli.Terminal;

public class MockTerminal
extends Terminal {
    private final ByteArrayOutputStream stdoutBuffer = new ByteArrayOutputStream();
    private final ByteArrayOutputStream stderrBuffer = new ByteArrayOutputStream();
    private final PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.stdoutBuffer, StandardCharsets.UTF_8));
    private final PrintWriter errorWriter = new PrintWriter(new OutputStreamWriter((OutputStream)this.stderrBuffer, StandardCharsets.UTF_8));
    private final List<String> textInput = new ArrayList<String>();
    private int textIndex = 0;
    private final List<String> secretInput = new ArrayList<String>();
    private int secretIndex = 0;

    public MockTerminal() {
        super("\n");
    }

    public String readText(String prompt) {
        if (this.textIndex >= this.textInput.size()) {
            throw new IllegalStateException("No text input configured for prompt [" + prompt + "]");
        }
        return this.textInput.get(this.textIndex++);
    }

    public char[] readSecret(String prompt) {
        if (this.secretIndex >= this.secretInput.size()) {
            throw new IllegalStateException("No secret input configured for prompt [" + prompt + "]");
        }
        return this.secretInput.get(this.secretIndex++).toCharArray();
    }

    public PrintWriter getWriter() {
        return this.writer;
    }

    public PrintWriter getErrorWriter() {
        return this.errorWriter;
    }

    public void addTextInput(String input) {
        this.textInput.add(input);
    }

    public void addSecretInput(String input) {
        this.secretInput.add(input);
    }

    public String getOutput() throws UnsupportedEncodingException {
        return this.stdoutBuffer.toString("UTF-8");
    }

    public String getErrorOutput() throws UnsupportedEncodingException {
        return this.stderrBuffer.toString("UTF-8");
    }

    public void reset() {
        this.stdoutBuffer.reset();
        this.stderrBuffer.reset();
        this.textIndex = 0;
        this.textInput.clear();
        this.secretIndex = 0;
        this.secretInput.clear();
    }
}

