/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import com.carrotsearch.hppc.LongObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;

public class LinearizabilityChecker {
    private static final Logger logger = LogManager.getLogger(LinearizabilityChecker.class);

    public boolean isLinearizable(SequentialSpec spec, History history, Function<Object, Object> missingResponseGenerator) {
        return this.isLinearizable(spec, history, missingResponseGenerator, () -> false);
    }

    public boolean isLinearizable(SequentialSpec spec, History history, Function<Object, Object> missingResponseGenerator, BooleanSupplier terminateEarly) {
        history = history.clone();
        history.complete(missingResponseGenerator);
        Collection<List<Event>> partitions = spec.partition(history.copyEvents());
        return partitions.stream().allMatch(h -> this.isLinearizable(spec, (List<Event>)h, terminateEarly));
    }

    private boolean isLinearizable(SequentialSpec spec, List<Event> history, BooleanSupplier terminateEarly) {
        logger.debug("Checking history of size: {}: {}", (Object)history.size(), history);
        Object state = spec.initialState();
        FixedBitSet linearized = new FixedBitSet(history.size() / 2);
        Cache cache = new Cache();
        LinkedList<Tuple> calls = new LinkedList<Tuple>();
        Entry headEntry = LinearizabilityChecker.createLinkedEntries(history);
        Entry entry = headEntry.next;
        while (headEntry.next != null) {
            if (terminateEarly.getAsBoolean()) {
                return false;
            }
            if (entry.match != null) {
                Optional<Object> maybeNextState = spec.nextState(state, entry.event.value, entry.match.event.value);
                boolean shouldExploreNextState = false;
                if (maybeNextState.isPresent()) {
                    FixedBitSet updatedLinearized = linearized.clone();
                    updatedLinearized.set(entry.id);
                    shouldExploreNextState = cache.add(maybeNextState.get(), updatedLinearized);
                }
                if (shouldExploreNextState) {
                    calls.push(new Tuple((Object)entry, state));
                    state = maybeNextState.get();
                    linearized.set(entry.id);
                    entry.lift();
                    entry = headEntry.next;
                    continue;
                }
                entry = entry.next;
                continue;
            }
            if (calls.isEmpty()) {
                return false;
            }
            Tuple top = (Tuple)calls.pop();
            entry = (Entry)top.v1();
            state = top.v2();
            linearized.clear(entry.id);
            entry.unlift();
            entry = entry.next;
        }
        return true;
    }

    public boolean isLinearizable(SequentialSpec spec, History history) {
        return this.isLinearizable(spec, history, (Object o) -> {
            throw new IllegalArgumentException("history is not complete");
        });
    }

    public static String visualize(SequentialSpec spec, History history, Function<Object, Object> missingResponseGenerator) {
        history = history.clone();
        history.complete(missingResponseGenerator);
        Collection<List<Event>> partitions = spec.partition(history.copyEvents());
        final StringBuilder builder = new StringBuilder();
        partitions.forEach(new Consumer<List<Event>>(){
            int index = 0;

            @Override
            public void accept(List<Event> events) {
                builder.append("Partition ").append(this.index++).append("\n");
                builder.append(LinearizabilityChecker.visualizePartition(events));
            }
        });
        return builder.toString();
    }

    private static String visualizePartition(List<Event> events) {
        StringBuilder builder = new StringBuilder();
        Entry entry = LinearizabilityChecker.createLinkedEntries(events).next;
        HashMap<Tuple<EventType, Integer>, Integer> eventToPosition = new HashMap<Tuple<EventType, Integer>, Integer>();
        for (Event event : events) {
            eventToPosition.put((Tuple<EventType, Integer>)Tuple.tuple((Object)((Object)event.type), (Object)event.id), eventToPosition.size());
        }
        while (entry != null) {
            if (entry.match != null) {
                builder.append(LinearizabilityChecker.visualizeEntry(entry, eventToPosition)).append("\n");
            }
            entry = entry.next;
        }
        return builder.toString();
    }

    private static String visualizeEntry(Entry entry, Map<Tuple<EventType, Integer>, Integer> eventToPosition) {
        String input = String.valueOf(entry.event.value);
        String output = String.valueOf(entry.match.event.value);
        int id = entry.event.id;
        int beginIndex = eventToPosition.get(Tuple.tuple((Object)((Object)EventType.INVOCATION), (Object)id));
        int endIndex = eventToPosition.get(Tuple.tuple((Object)((Object)EventType.RESPONSE), (Object)id));
        input = input.substring(0, Math.min(beginIndex + 25, input.length()));
        return Strings.padStart((String)input, (int)(beginIndex + 25), (char)' ') + "   " + Strings.padStart((String)"", (int)(endIndex - beginIndex), (char)'X') + "   " + output + "  (" + entry.event.id + ")";
    }

    private static Entry createLinkedEntries(List<Event> history) {
        Entry first;
        if (history.size() % 2 != 0) {
            throw new IllegalArgumentException("mismatch between number of invocations and responses");
        }
        HashMap<Integer, Entry> matches = new HashMap<Integer, Entry>();
        Entry[] entries = new Entry[history.size()];
        int nextInternalId = history.size() / 2 - 1;
        for (int i = history.size() - 1; i >= 0; --i) {
            Event elem = history.get(i);
            if (elem.type == EventType.RESPONSE) {
                Entry entry = entries[i] = new Entry(elem, null, nextInternalId--);
                Entry prev = matches.put(elem.id, entry);
                if (prev == null) continue;
                throw new IllegalArgumentException("duplicate response with id " + elem.id);
            }
            Entry matchingResponse = (Entry)matches.get(elem.id);
            if (matchingResponse == null) {
                throw new IllegalArgumentException("no matching response found for " + elem);
            }
            entries[i] = new Entry(elem, matchingResponse, matchingResponse.id);
        }
        if (nextInternalId != -1) {
            throw new IllegalArgumentException("id mismatch");
        }
        Entry lastEntry = first = new Entry(null, null, -1);
        Entry[] entryArray = entries;
        int n = entryArray.length;
        for (int i = 0; i < n; ++i) {
            Entry entry;
            lastEntry.next = entry = entryArray[i];
            entry.prev = lastEntry;
            lastEntry = entry;
        }
        return first;
    }

    public static interface SequentialSpec {
        public Object initialState();

        public Optional<Object> nextState(Object var1, Object var2, Object var3);

        default public Collection<List<Event>> partition(List<Event> events) {
            return Collections.singleton(events);
        }
    }

    public static class History {
        private final Queue<Event> events;
        private AtomicInteger nextId = new AtomicInteger();

        public History() {
            this.events = new ConcurrentLinkedQueue<Event>();
        }

        public History(Collection<Event> events) {
            this();
            this.events.addAll(events);
            this.nextId.set(events.stream().mapToInt(e -> e.id).max().orElse(-1) + 1);
        }

        public int invoke(Object input) {
            int id = this.nextId.getAndIncrement();
            this.events.add(new Event(EventType.INVOCATION, input, id));
            return id;
        }

        public void respond(int id, Object output) {
            this.events.add(new Event(EventType.RESPONSE, output, id));
        }

        public void remove(int id) {
            this.events.removeIf(e -> e.id == id);
        }

        public List<Event> copyEvents() {
            return new ArrayList<Event>(this.events);
        }

        public void complete(Function<Object, Object> missingResponseGenerator) {
            HashMap<Integer, Event> uncompletedInvocations = new HashMap<Integer, Event>();
            for (Event event : this.events) {
                if (event.type == EventType.INVOCATION) {
                    uncompletedInvocations.put(event.id, event);
                    continue;
                }
                Event removed = (Event)uncompletedInvocations.remove(event.id);
                if (removed != null) continue;
                throw new IllegalArgumentException("history not well-formed: " + this.events);
            }
            for (Map.Entry entry : uncompletedInvocations.entrySet()) {
                this.events.add(new Event(EventType.RESPONSE, missingResponseGenerator.apply(((Event)entry.getValue()).value), (Integer)entry.getKey()));
            }
        }

        public History clone() {
            return new History(this.events);
        }

        public int size() {
            return this.events.size();
        }

        public String toString() {
            return "History{events=" + this.events + ", nextId=" + this.nextId + '}';
        }
    }

    private static class Cache {
        private final Map<Object, Set<FixedBitSet>> largeMap = new HashMap<Object, Set<FixedBitSet>>();
        private final LongObjectHashMap<Set<Object>> smallMap = new LongObjectHashMap();
        private final Map<Object, Object> internalizeStateMap = new HashMap<Object, Object>();
        private final Map<Set<Object>, Set<Object>> statePermutations = new HashMap<Set<Object>, Set<Object>>();

        private Cache() {
        }

        public boolean add(Object state, FixedBitSet bitSet) {
            return this.addInternal(this.internalizeStateMap.computeIfAbsent(state, k -> state), bitSet);
        }

        private boolean addInternal(Object state, FixedBitSet bitSet) {
            long[] bits = bitSet.getBits();
            if (bits.length == 1) {
                return this.addSmall(state, bits[0]);
            }
            return this.addLarge(state, bitSet);
        }

        private boolean addSmall(Object state, long bits) {
            HashSet<Object> states;
            int index = this.smallMap.indexOf(bits);
            if (index < 0) {
                states = Collections.singleton(state);
            } else {
                Set oldStates = (Set)this.smallMap.indexGet(index);
                if (oldStates.contains(state)) {
                    return false;
                }
                states = new HashSet<Object>(oldStates.size() + 1);
                states.addAll(oldStates);
                states.add(state);
            }
            states = this.statePermutations.computeIfAbsent(states, k -> k);
            if (index < 0) {
                this.smallMap.indexInsert(index, bits, states);
            } else {
                this.smallMap.indexReplace(index, (Object)states);
            }
            return true;
        }

        private boolean addLarge(Object state, FixedBitSet bitSet) {
            return this.largeMap.computeIfAbsent(state, k -> new HashSet()).add(bitSet);
        }
    }

    static class Entry {
        final Event event;
        final Entry match;
        final int id;
        Entry prev;
        Entry next;

        Entry(Event event, Entry match, int id) {
            this.event = event;
            this.match = match;
            this.id = id;
        }

        void lift() {
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.match.prev.next = this.match.next;
            if (this.match.next != null) {
                this.match.next.prev = this.match.prev;
            }
        }

        void unlift() {
            this.match.prev.next = this.match;
            if (this.match.next != null) {
                this.match.next.prev = this.match;
            }
            this.prev.next = this;
            this.next.prev = this;
        }
    }

    public static class Event {
        public final EventType type;
        public final Object value;
        public final int id;

        public Event(EventType type, Object value, int id) {
            this.type = type;
            this.value = value;
            this.id = id;
        }

        public String toString() {
            return "Event{type=" + (Object)((Object)this.type) + ", value=" + this.value + ", id=" + this.id + '}';
        }
    }

    public static enum EventType {
        INVOCATION,
        RESPONSE;

    }

    public static interface KeyedSpec
    extends SequentialSpec {
        public Object getKey(Object var1);

        public Object getValue(Object var1);

        @Override
        default public Collection<List<Event>> partition(List<Event> events) {
            HashMap<Object, List> keyedPartitions = new HashMap<Object, List>();
            HashMap<Integer, Object> matches = new HashMap<Integer, Object>();
            for (Event event : events) {
                Object key;
                if (event.type == EventType.INVOCATION) {
                    key = this.getKey(event.value);
                    Object val = this.getValue(event.value);
                    Event unfoldedEvent = new Event(EventType.INVOCATION, val, event.id);
                    keyedPartitions.computeIfAbsent(key, k -> new ArrayList()).add(unfoldedEvent);
                    matches.put(event.id, key);
                    continue;
                }
                key = matches.get(event.id);
                ((List)keyedPartitions.get(key)).add(event);
            }
            return keyedPartitions.values();
        }
    }
}

