/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.RandomIndexWriter;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.indices.IndicesModule;
import org.elasticsearch.indices.mapper.MapperRegistry;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.ScriptPlugin;
import org.elasticsearch.script.ScriptModule;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.test.ESTestCase;
import org.mockito.Matchers;
import org.mockito.Mockito;

public abstract class MapperServiceTestCase
extends ESTestCase {
    protected static final Settings SETTINGS = Settings.builder().put("index.version.created", Version.CURRENT).build();
    protected static final ToXContent.Params INCLUDE_DEFAULTS = new ToXContent.MapParams(Collections.singletonMap("include_defaults", "true"));

    protected Collection<? extends Plugin> getPlugins() {
        return Collections.emptyList();
    }

    protected Settings getIndexSettings() {
        return SETTINGS;
    }

    protected IndexAnalyzers createIndexAnalyzers(IndexSettings indexSettings) {
        return new IndexAnalyzers(Collections.singletonMap("default", new NamedAnalyzer("default", AnalyzerScope.INDEX, (Analyzer)new StandardAnalyzer())), Collections.emptyMap(), Collections.emptyMap());
    }

    protected final String randomIndexOptions() {
        return MapperServiceTestCase.randomFrom("docs", "freqs", "positions", "offsets");
    }

    protected final DocumentMapper createDocumentMapper(XContentBuilder mappings) throws IOException {
        return this.createMapperService(mappings).documentMapper();
    }

    protected final DocumentMapper createDocumentMapper(Version version, XContentBuilder mappings) throws IOException {
        return this.createMapperService(version, mappings).documentMapper();
    }

    protected final DocumentMapper createDocumentMapper(String type, String mappings) throws IOException {
        MapperService mapperService = this.createMapperService(this.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {})));
        this.merge(type, mapperService, mappings);
        return mapperService.documentMapper();
    }

    protected MapperService createMapperService(XContentBuilder mappings) throws IOException {
        return this.createMapperService(Version.CURRENT, mappings);
    }

    protected final MapperService createMapperService(String type, String mappings) throws IOException {
        MapperService mapperService = this.createMapperService(this.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {})));
        this.merge(type, mapperService, mappings);
        return mapperService;
    }

    protected final MapperService createMapperService(Version version, XContentBuilder mapping) throws IOException {
        IndexMetadata meta = IndexMetadata.builder((String)"index").settings(Settings.builder().put("index.version.created", version)).numberOfReplicas(0).numberOfShards(1).build();
        IndexSettings indexSettings = new IndexSettings(meta, this.getIndexSettings());
        MapperRegistry mapperRegistry = new IndicesModule(this.getPlugins().stream().filter(p -> p instanceof MapperPlugin).map(p -> (MapperPlugin)p).collect(Collectors.toList())).getMapperRegistry();
        ScriptModule scriptModule = new ScriptModule(Settings.EMPTY, this.getPlugins().stream().filter(p -> p instanceof ScriptPlugin).map(p -> (ScriptPlugin)p).collect(Collectors.toList()));
        ScriptService scriptService = new ScriptService(this.getIndexSettings(), scriptModule.engines, scriptModule.contexts);
        SimilarityService similarityService = new SimilarityService(indexSettings, scriptService, Collections.emptyMap());
        MapperService mapperService = new MapperService(indexSettings, this.createIndexAnalyzers(indexSettings), this.xContentRegistry(), similarityService, mapperRegistry, () -> {
            throw new UnsupportedOperationException();
        }, () -> true, scriptService);
        this.merge(mapperService, mapping);
        return mapperService;
    }

    protected final void withLuceneIndex(MapperService mapperService, CheckedConsumer<RandomIndexWriter, IOException> builder, CheckedConsumer<IndexReader, IOException> test) throws IOException {
        try (BaseDirectoryWrapper dir = MapperServiceTestCase.newDirectory();
             RandomIndexWriter iw = new RandomIndexWriter(MapperServiceTestCase.random(), (Directory)dir, new IndexWriterConfig(mapperService.indexAnalyzer()));){
            builder.accept((Object)iw);
            try (DirectoryReader reader = iw.getReader();){
                test.accept((Object)reader);
            }
        }
    }

    protected final SourceToParse source(CheckedConsumer<XContentBuilder, IOException> build) throws IOException {
        XContentBuilder builder = JsonXContent.contentBuilder().startObject();
        build.accept((Object)builder);
        builder.endObject();
        return new SourceToParse("test", "_doc", "1", BytesReference.bytes((XContentBuilder)builder), XContentType.JSON);
    }

    protected final SourceToParse source(String source) {
        return new SourceToParse("test", "_doc", "1", (BytesReference)new BytesArray(source), XContentType.JSON);
    }

    protected final void merge(MapperService mapperService, XContentBuilder mapping) throws IOException {
        this.merge(mapperService, MapperService.MergeReason.MAPPING_UPDATE, mapping);
    }

    protected final void merge(String type, MapperService mapperService, String mapping) throws IOException {
        mapperService.merge(type, new CompressedXContent(mapping), MapperService.MergeReason.MAPPING_UPDATE);
    }

    protected final void merge(MapperService mapperService, MapperService.MergeReason reason, XContentBuilder mapping) throws IOException {
        mapperService.merge("_doc", new CompressedXContent(BytesReference.bytes((XContentBuilder)mapping)), reason);
    }

    protected final XContentBuilder topMapping(CheckedConsumer<XContentBuilder, IOException> buildFields) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject().startObject("_doc");
        buildFields.accept((Object)builder);
        return builder.endObject().endObject();
    }

    protected final XContentBuilder mapping(CheckedConsumer<XContentBuilder, IOException> buildFields) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject().startObject("_doc").startObject("properties");
        buildFields.accept((Object)builder);
        return builder.endObject().endObject().endObject();
    }

    protected final XContentBuilder dynamicMapping(Mapping dynamicMapping) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
        dynamicMapping.toXContent(builder, ToXContent.EMPTY_PARAMS);
        return builder.endObject();
    }

    protected final XContentBuilder fieldMapping(CheckedConsumer<XContentBuilder, IOException> buildField) throws IOException {
        return this.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("field");
            buildField.accept(b);
            b.endObject();
        }));
    }

    QueryShardContext createQueryShardContext(MapperService mapperService) {
        QueryShardContext queryShardContext = (QueryShardContext)Mockito.mock(QueryShardContext.class);
        Mockito.when((Object)queryShardContext.getMapperService()).thenReturn((Object)mapperService);
        Mockito.when((Object)queryShardContext.fieldMapper(Matchers.anyString())).thenAnswer(inv -> mapperService.fieldType(inv.getArguments()[0].toString()));
        Mockito.when((Object)queryShardContext.getIndexAnalyzers()).thenReturn((Object)mapperService.getIndexAnalyzers());
        Mockito.when((Object)queryShardContext.getSearchQuoteAnalyzer((MappedFieldType)Matchers.anyObject())).thenCallRealMethod();
        Mockito.when((Object)queryShardContext.getSearchAnalyzer((MappedFieldType)Matchers.anyObject())).thenCallRealMethod();
        Mockito.when((Object)queryShardContext.getIndexSettings()).thenReturn((Object)mapperService.getIndexSettings());
        Mockito.when((Object)queryShardContext.simpleMatchToIndexNames((String)Matchers.anyObject())).thenAnswer(inv -> mapperService.simpleMatchToFullName(inv.getArguments()[0].toString()));
        Mockito.when((Object)queryShardContext.allowExpensiveQueries()).thenReturn((Object)true);
        Mockito.when((Object)queryShardContext.lookup()).thenReturn((Object)new SearchLookup(mapperService, (ft, s) -> {
            throw new UnsupportedOperationException("search lookup not available");
        }, null));
        return queryShardContext;
    }
}

