/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesResponse;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotResponse;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsResponse;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.SnapshotDeletionsInProgress;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.metadata.RepositoriesMetadata;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.routing.allocation.decider.EnableAllocationDecider;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.CheckedRunnable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.ShardGenerations;
import org.elasticsearch.repositories.blobstore.BlobStoreTestUtil;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotState;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.snapshots.mockstore.MockRepository;
import org.elasticsearch.test.ESIntegTestCase;
import org.elasticsearch.test.VersionUtils;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.threadpool.ThreadPoolStats;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;

public abstract class AbstractSnapshotIntegTestCase
extends ESIntegTestCase {
    private static final String OLD_VERSION_SNAPSHOT_PREFIX = "old-version-snapshot-";
    protected static final Settings LARGE_SNAPSHOT_POOL_SETTINGS = Settings.builder().put("thread_pool.snapshot.core", 5).put("thread_pool.snapshot.max", 5).build();
    private String skipRepoConsistencyCheckReason;
    private static final Settings SINGLE_SHARD_NO_REPLICA = AbstractSnapshotIntegTestCase.indexSettingsNoReplicas(1).build();

    @Override
    protected Settings nodeSettings(int nodeOrdinal) {
        return Settings.builder().put(super.nodeSettings(nodeOrdinal)).put(EnableAllocationDecider.CLUSTER_ROUTING_REBALANCE_ENABLE_SETTING.getKey(), (Enum)EnableAllocationDecider.Rebalance.NONE).build();
    }

    @Override
    protected Collection<Class<? extends Plugin>> nodePlugins() {
        return Arrays.asList(MockRepository.Plugin.class);
    }

    @After
    public void assertConsistentHistoryInLuceneIndex() throws Exception {
        AbstractSnapshotIntegTestCase.internalCluster().assertConsistentHistoryBetweenTranslogAndLuceneIndex();
    }

    @After
    public void verifyNoLeakedListeners() throws Exception {
        AbstractSnapshotIntegTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            for (SnapshotsService snapshotsService : AbstractSnapshotIntegTestCase.internalCluster().getInstances(SnapshotsService.class)) {
                AbstractSnapshotIntegTestCase.assertTrue((boolean)snapshotsService.assertAllListenersResolved());
            }
        }), 30L, TimeUnit.SECONDS);
    }

    @After
    public void assertRepoConsistency() {
        if (this.skipRepoConsistencyCheckReason == null) {
            ((GetRepositoriesResponse)this.clusterAdmin().prepareGetRepositories(new String[0]).get()).repositories().forEach(repositoryMetadata -> {
                String name = repositoryMetadata.name();
                if (!repositoryMetadata.settings().getAsBoolean("readonly", Boolean.valueOf(false)).booleanValue()) {
                    this.clusterAdmin().prepareDeleteSnapshot(name, new String[]{"old-version-snapshot-*"}).get();
                    this.clusterAdmin().prepareCleanupRepository(name).get();
                }
                BlobStoreTestUtil.assertRepoConsistency(AbstractSnapshotIntegTestCase.internalCluster(), name);
            });
        } else {
            this.logger.info("--> skipped repo consistency checks because [{}]", (Object)this.skipRepoConsistencyCheckReason);
        }
    }

    protected void disableRepoConsistencyCheck(String reason) {
        AbstractSnapshotIntegTestCase.assertNotNull((Object)reason);
        this.skipRepoConsistencyCheckReason = reason;
    }

    protected RepositoryData getRepositoryData(String repository) {
        return this.getRepositoryData(AbstractSnapshotIntegTestCase.internalCluster().getCurrentMasterNodeInstance(RepositoriesService.class).repository(repository));
    }

    protected RepositoryData getRepositoryData(Repository repository) {
        return (RepositoryData)PlainActionFuture.get(arg_0 -> ((Repository)repository).getRepositoryData(arg_0));
    }

    public static long getFailureCount(String repository) {
        long failureCount = 0L;
        for (RepositoriesService repositoriesService : AbstractSnapshotIntegTestCase.internalCluster().getDataOrMasterNodeInstances(RepositoriesService.class)) {
            MockRepository mockRepository = (MockRepository)repositoriesService.repository(repository);
            failureCount += mockRepository.getFailureCount();
        }
        return failureCount;
    }

    public static void assertFileCount(Path dir, int expectedCount) throws IOException {
        final ArrayList found = new ArrayList();
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                found.add(file);
                return FileVisitResult.CONTINUE;
            }
        });
        AbstractSnapshotIntegTestCase.assertEquals((String)("Unexpected file count, found: [" + found + "]."), (long)expectedCount, (long)found.size());
    }

    public static int numberOfFiles(Path dir) throws IOException {
        final AtomicInteger count = new AtomicInteger();
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                count.incrementAndGet();
                return FileVisitResult.CONTINUE;
            }
        });
        return count.get();
    }

    public static void stopNode(String node) throws IOException {
        AbstractSnapshotIntegTestCase.internalCluster().stopRandomNode(settings -> settings.get("node.name").equals(node));
    }

    public void waitForBlock(String node, String repository, TimeValue timeout) throws InterruptedException {
        this.logger.info("--> waiting for [{}] to be blocked on node [{}]", (Object)repository, (Object)node);
        long start = System.currentTimeMillis();
        RepositoriesService repositoriesService = AbstractSnapshotIntegTestCase.internalCluster().getInstance(RepositoriesService.class, node);
        MockRepository mockRepository = (MockRepository)repositoriesService.repository(repository);
        while (System.currentTimeMillis() - start < timeout.millis()) {
            if (mockRepository.blocked()) {
                return;
            }
            Thread.sleep(100L);
        }
        AbstractSnapshotIntegTestCase.fail((String)("Timeout waiting for node [" + node + "] to be blocked"));
    }

    public SnapshotInfo waitForCompletion(String repository, String snapshotName, TimeValue timeout) throws InterruptedException {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < timeout.millis()) {
            SnapshotInfo snapshotInfo = this.getSnapshot(repository, snapshotName);
            if (snapshotInfo.state().completed()) {
                ClusterStateResponse stateResponse = (ClusterStateResponse)this.clusterAdmin().prepareState().get();
                boolean found = false;
                for (SnapshotsInProgress.Entry entry : ((SnapshotsInProgress)stateResponse.getState().custom("snapshots", (ClusterState.Custom)SnapshotsInProgress.EMPTY)).entries()) {
                    Snapshot curr = entry.snapshot();
                    if (!curr.getRepository().equals(repository) || !curr.getSnapshotId().getName().equals(snapshotName)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return snapshotInfo;
                }
            }
            Thread.sleep(100L);
        }
        AbstractSnapshotIntegTestCase.fail((String)"Timeout!!!");
        return null;
    }

    public static String blockMasterFromFinalizingSnapshotOnIndexFile(String repositoryName) {
        String masterName = AbstractSnapshotIntegTestCase.internalCluster().getMasterName();
        ((MockRepository)AbstractSnapshotIntegTestCase.internalCluster().getInstance(RepositoriesService.class, masterName).repository(repositoryName)).setBlockAndFailOnWriteIndexFile();
        return masterName;
    }

    public static String blockMasterOnWriteIndexFile(String repositoryName) {
        String masterName = AbstractSnapshotIntegTestCase.internalCluster().getMasterName();
        ((MockRepository)AbstractSnapshotIntegTestCase.internalCluster().getMasterNodeInstance(RepositoriesService.class).repository(repositoryName)).setBlockOnWriteIndexFile();
        return masterName;
    }

    public static void blockMasterFromDeletingIndexNFile(String repositoryName) {
        String masterName = AbstractSnapshotIntegTestCase.internalCluster().getMasterName();
        ((MockRepository)AbstractSnapshotIntegTestCase.internalCluster().getInstance(RepositoriesService.class, masterName).repository(repositoryName)).setBlockOnDeleteIndexFile();
    }

    public static String blockMasterFromFinalizingSnapshotOnSnapFile(String repositoryName) {
        String masterName = AbstractSnapshotIntegTestCase.internalCluster().getMasterName();
        ((MockRepository)AbstractSnapshotIntegTestCase.internalCluster().getInstance(RepositoriesService.class, masterName).repository(repositoryName)).setBlockAndFailOnWriteSnapFiles(true);
        return masterName;
    }

    public static String blockNodeWithIndex(String repositoryName, String indexName) {
        Iterator<String> iterator = AbstractSnapshotIntegTestCase.internalCluster().nodesInclude(indexName).iterator();
        if (iterator.hasNext()) {
            String node = iterator.next();
            ((MockRepository)AbstractSnapshotIntegTestCase.internalCluster().getInstance(RepositoriesService.class, node).repository(repositoryName)).blockOnDataFiles(true);
            return node;
        }
        AbstractSnapshotIntegTestCase.fail((String)("No nodes for the index " + indexName + " found"));
        return null;
    }

    public static void blockNodeOnAnyFiles(String repository, String nodeName) {
        ((MockRepository)AbstractSnapshotIntegTestCase.internalCluster().getInstance(RepositoriesService.class, nodeName).repository(repository)).setBlockOnAnyFiles(true);
    }

    public static void blockDataNode(String repository, String nodeName) {
        ((MockRepository)AbstractSnapshotIntegTestCase.internalCluster().getInstance(RepositoriesService.class, nodeName).repository(repository)).blockOnDataFiles(true);
    }

    public static void blockAllDataNodes(String repository) {
        for (RepositoriesService repositoriesService : AbstractSnapshotIntegTestCase.internalCluster().getDataNodeInstances(RepositoriesService.class)) {
            ((MockRepository)repositoriesService.repository(repository)).blockOnDataFiles(true);
        }
    }

    public static void unblockAllDataNodes(String repository) {
        for (RepositoriesService repositoriesService : AbstractSnapshotIntegTestCase.internalCluster().getDataNodeInstances(RepositoriesService.class)) {
            ((MockRepository)repositoriesService.repository(repository)).unblock();
        }
    }

    public static void failReadsAllDataNodes(String repository) {
        for (RepositoriesService repositoriesService : AbstractSnapshotIntegTestCase.internalCluster().getDataNodeInstances(RepositoriesService.class)) {
            MockRepository mockRepository = (MockRepository)repositoriesService.repository(repository);
            mockRepository.setFailReadsAfterUnblock(true);
        }
    }

    public static void waitForBlockOnAnyDataNode(String repository, TimeValue timeout) throws InterruptedException {
        boolean blocked = AbstractSnapshotIntegTestCase.waitUntil(() -> {
            for (RepositoriesService repositoriesService : AbstractSnapshotIntegTestCase.internalCluster().getDataNodeInstances(RepositoriesService.class)) {
                MockRepository mockRepository = (MockRepository)repositoriesService.repository(repository);
                if (!mockRepository.blocked()) continue;
                return true;
            }
            return false;
        }, timeout.millis(), TimeUnit.MILLISECONDS);
        AbstractSnapshotIntegTestCase.assertTrue((String)"No repository is blocked waiting on a data node", (boolean)blocked);
    }

    public void unblockNode(String repository, String node) {
        this.logger.info("--> unblocking [{}] on node [{}]", (Object)repository, (Object)node);
        ((MockRepository)AbstractSnapshotIntegTestCase.internalCluster().getInstance(RepositoriesService.class, node).repository(repository)).unblock();
    }

    protected void createRepository(String repoName, String type, Settings.Builder settings) {
        this.logger.info("--> creating repository [{}] [{}]", (Object)repoName, (Object)type);
        ElasticsearchAssertions.assertAcked(this.clusterAdmin().preparePutRepository(repoName).setType(type).setSettings(settings));
    }

    protected void createRepository(String repoName, String type, Path location) {
        this.createRepository(repoName, type, Settings.builder().put("location", location));
    }

    protected void createRepository(String repoName, String type) {
        this.createRepository(repoName, type, this.randomRepositorySettings());
    }

    protected Settings.Builder randomRepositorySettings() {
        Settings.Builder settings = Settings.builder();
        settings.put("location", this.randomRepoPath()).put("compress", AbstractSnapshotIntegTestCase.randomBoolean());
        if (AbstractSnapshotIntegTestCase.rarely()) {
            settings.put("chunk_size", (long)AbstractSnapshotIntegTestCase.randomIntBetween(100, 1000), ByteSizeUnit.BYTES);
        }
        return settings;
    }

    protected static Settings.Builder indexSettingsNoReplicas(int shards) {
        return Settings.builder().put("index.number_of_shards", shards).put("index.number_of_replicas", 0);
    }

    protected void maybeInitWithOldSnapshotVersion(String repoName, Path repoPath) throws IOException {
        if (AbstractSnapshotIntegTestCase.randomBoolean() && AbstractSnapshotIntegTestCase.randomBoolean()) {
            this.initWithSnapshotVersion(repoName, repoPath, VersionUtils.randomIndexCompatibleVersion(AbstractSnapshotIntegTestCase.random()));
        }
    }

    protected String initWithSnapshotVersion(String repoName, Path repoPath, Version version) throws IOException {
        AbstractSnapshotIntegTestCase.assertThat((String)"This hack only works on an empty repository", (Object)this.getRepositoryData(repoName).getSnapshotIds(), (Matcher)Matchers.empty());
        String oldVersionSnapshot = OLD_VERSION_SNAPSHOT_PREFIX + version.id;
        CreateSnapshotResponse createSnapshotResponse = (CreateSnapshotResponse)this.clusterAdmin().prepareCreateSnapshot(repoName, oldVersionSnapshot).setIndices(new String[]{"does-not-exist-for-sure-*"}).setWaitForCompletion(true).get();
        AbstractSnapshotIntegTestCase.assertThat((Object)createSnapshotResponse.getSnapshotInfo().totalShards(), (Matcher)Matchers.is((Object)0));
        this.logger.info("--> writing downgraded RepositoryData for repository metadata version [{}]", (Object)version);
        RepositoryData repositoryData = this.getRepositoryData(repoName);
        XContentBuilder jsonBuilder = JsonXContent.contentBuilder();
        repositoryData.snapshotsToXContent(jsonBuilder, version);
        RepositoryData downgradedRepoData = RepositoryData.snapshotsFromXContent((XContentParser)JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, Strings.toString((XContentBuilder)jsonBuilder).replace(Version.CURRENT.toString(), version.toString())), (long)repositoryData.getGenId(), (boolean)AbstractSnapshotIntegTestCase.randomBoolean());
        Files.write(repoPath.resolve("index-" + repositoryData.getGenId()), BytesReference.toBytes((BytesReference)BytesReference.bytes((XContentBuilder)downgradedRepoData.snapshotsToXContent(XContentFactory.jsonBuilder(), version))), StandardOpenOption.TRUNCATE_EXISTING);
        return oldVersionSnapshot;
    }

    protected SnapshotInfo createFullSnapshot(String repoName, String snapshotName) {
        this.logger.info("--> creating full snapshot [{}] in [{}]", (Object)snapshotName, (Object)repoName);
        CreateSnapshotResponse createSnapshotResponse = (CreateSnapshotResponse)this.clusterAdmin().prepareCreateSnapshot(repoName, snapshotName).setIncludeGlobalState(true).setWaitForCompletion(true).get();
        SnapshotInfo snapshotInfo = createSnapshotResponse.getSnapshotInfo();
        AbstractSnapshotIntegTestCase.assertThat((Object)snapshotInfo.successfulShards(), (Matcher)Matchers.is((Object)snapshotInfo.totalShards()));
        AbstractSnapshotIntegTestCase.assertThat((Object)snapshotInfo.state(), (Matcher)Matchers.is((Object)SnapshotState.SUCCESS));
        return snapshotInfo;
    }

    protected SnapshotInfo createSnapshot(String repositoryName, String snapshot, List<String> indices) {
        this.logger.info("--> creating snapshot [{}] of {} in [{}]", (Object)snapshot, indices, (Object)repositoryName);
        CreateSnapshotResponse response = (CreateSnapshotResponse)AbstractSnapshotIntegTestCase.client().admin().cluster().prepareCreateSnapshot(repositoryName, snapshot).setIndices(indices.toArray(Strings.EMPTY_ARRAY)).setWaitForCompletion(true).get();
        SnapshotInfo snapshotInfo = response.getSnapshotInfo();
        AbstractSnapshotIntegTestCase.assertThat((Object)snapshotInfo.state(), (Matcher)Matchers.is((Object)SnapshotState.SUCCESS));
        AbstractSnapshotIntegTestCase.assertThat((Object)snapshotInfo.successfulShards(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        AbstractSnapshotIntegTestCase.assertThat((Object)snapshotInfo.failedShards(), (Matcher)Matchers.equalTo((Object)0));
        return snapshotInfo;
    }

    protected void createIndexWithRandomDocs(String indexName, int docCount) throws InterruptedException {
        this.createIndex(indexName);
        this.ensureGreen(new String[0]);
        this.indexRandomDocs(indexName, docCount);
    }

    protected void indexRandomDocs(String index, int numdocs) throws InterruptedException {
        this.logger.info("--> indexing [{}] documents into [{}]", (Object)numdocs, (Object)index);
        IndexRequestBuilder[] builders = new IndexRequestBuilder[numdocs];
        for (int i = 0; i < builders.length; ++i) {
            builders[i] = AbstractSnapshotIntegTestCase.client().prepareIndex(index, "_doc").setId(Integer.toString(i)).setSource(new Object[]{"field1", "bar " + i});
        }
        this.indexRandom(true, builders);
        this.flushAndRefresh(index);
        this.assertDocCount(index, numdocs);
    }

    protected long getCountForIndex(String indexName) {
        return ((SearchResponse)AbstractSnapshotIntegTestCase.client().search((SearchRequest)new SearchRequest((SearchRequest)new SearchRequest((String[])new String[]{indexName}).source((SearchSourceBuilder)new SearchSourceBuilder().size((int)0).trackTotalHits((boolean)true)))).actionGet()).getHits().getTotalHits().value;
    }

    protected void assertDocCount(String index, long count) {
        AbstractSnapshotIntegTestCase.assertEquals((long)this.getCountForIndex(index), (long)count);
    }

    protected void addBwCFailedSnapshot(String repoName, String snapshotName, Map<String, Object> metadata) throws Exception {
        ClusterState state = ((ClusterStateResponse)this.clusterAdmin().prepareState().get()).getState();
        RepositoriesMetadata repositoriesMetadata = (RepositoriesMetadata)state.metadata().custom("repositories");
        AbstractSnapshotIntegTestCase.assertNotNull((Object)repositoriesMetadata);
        RepositoryMetadata initialRepoMetadata = repositoriesMetadata.repository(repoName);
        AbstractSnapshotIntegTestCase.assertNotNull((Object)initialRepoMetadata);
        AbstractSnapshotIntegTestCase.assertThat((String)"We can only manually insert a snapshot into a repository that does not have a generation tracked in the CS", (Object)initialRepoMetadata.generation(), (Matcher)Matchers.is((Object)-2L));
        Repository repo = AbstractSnapshotIntegTestCase.internalCluster().getCurrentMasterNodeInstance(RepositoriesService.class).repository(repoName);
        SnapshotId snapshotId = new SnapshotId(snapshotName, UUIDs.randomBase64UUID((Random)AbstractSnapshotIntegTestCase.random()));
        this.logger.info("--> adding old version FAILED snapshot [{}] to repository [{}]", (Object)snapshotId, (Object)repoName);
        SnapshotInfo snapshotInfo = new SnapshotInfo(snapshotId, Collections.emptyList(), Collections.emptyList(), SnapshotState.FAILED, "failed on purpose", SnapshotsService.OLD_SNAPSHOT_FORMAT, 0L, 0L, 0, 0, Collections.emptyList(), Boolean.valueOf(AbstractSnapshotIntegTestCase.randomBoolean()), metadata);
        PlainActionFuture.get(f -> repo.finalizeSnapshot(ShardGenerations.EMPTY, this.getRepositoryData(repoName).getGenId(), state.metadata(), snapshotInfo, SnapshotsService.OLD_SNAPSHOT_FORMAT, Function.identity(), (ActionListener)f));
    }

    protected void awaitNoMoreRunningOperations() throws Exception {
        this.awaitNoMoreRunningOperations(AbstractSnapshotIntegTestCase.internalCluster().getMasterName());
    }

    protected void awaitNoMoreRunningOperations(String viaNode) throws Exception {
        this.logger.info("--> verify no more operations in the cluster state");
        this.awaitClusterState(viaNode, state -> ((SnapshotsInProgress)state.custom("snapshots", (ClusterState.Custom)SnapshotsInProgress.EMPTY)).entries().isEmpty() && !((SnapshotDeletionsInProgress)state.custom("snapshot_deletions", (ClusterState.Custom)SnapshotDeletionsInProgress.EMPTY)).hasDeletionsInProgress());
    }

    protected void awaitClusterState(Predicate<ClusterState> statePredicate) throws Exception {
        this.awaitClusterState(AbstractSnapshotIntegTestCase.internalCluster().getMasterName(), statePredicate);
    }

    protected void awaitClusterState(String viaNode, Predicate<ClusterState> statePredicate) throws Exception {
        ThreadPool threadPool;
        final ClusterService clusterService = AbstractSnapshotIntegTestCase.internalCluster().getInstance(ClusterService.class, viaNode);
        ClusterStateObserver observer = new ClusterStateObserver(clusterService, this.logger, (threadPool = AbstractSnapshotIntegTestCase.internalCluster().getInstance(ThreadPool.class, viaNode)).getThreadContext());
        if (!statePredicate.test(observer.setAndGetObservedState())) {
            final PlainActionFuture future = PlainActionFuture.newFuture();
            observer.waitForNextChange(new ClusterStateObserver.Listener(){

                public void onNewClusterState(ClusterState state) {
                    future.onResponse(null);
                }

                public void onClusterServiceClose() {
                    future.onFailure((Exception)new NodeClosedException(clusterService.localNode()));
                }

                public void onTimeout(TimeValue timeout) {
                    future.onFailure((Exception)new TimeoutException());
                }
            }, statePredicate);
            future.get(30L, TimeUnit.SECONDS);
        }
    }

    protected ActionFuture<CreateSnapshotResponse> startFullSnapshotBlockedOnDataNode(String snapshotName, String repoName, String dataNode) throws InterruptedException {
        AbstractSnapshotIntegTestCase.blockDataNode(repoName, dataNode);
        ActionFuture<CreateSnapshotResponse> fut = this.startFullSnapshot(repoName, snapshotName);
        this.waitForBlock(dataNode, repoName, TimeValue.timeValueSeconds((long)30L));
        return fut;
    }

    protected ActionFuture<CreateSnapshotResponse> startFullSnapshot(String repoName, String snapshotName) {
        return this.startFullSnapshot(repoName, snapshotName, false);
    }

    protected ActionFuture<CreateSnapshotResponse> startFullSnapshot(String repoName, String snapshotName, boolean partial) {
        this.logger.info("--> creating full snapshot [{}] to repo [{}]", (Object)snapshotName, (Object)repoName);
        return this.clusterAdmin().prepareCreateSnapshot(repoName, snapshotName).setWaitForCompletion(true).setPartial(partial).execute();
    }

    protected void awaitNumberOfSnapshotsInProgress(int count) throws Exception {
        this.logger.info("--> wait for [{}] snapshots to show up in the cluster state", (Object)count);
        this.awaitClusterState(state -> ((SnapshotsInProgress)state.custom("snapshots", (ClusterState.Custom)SnapshotsInProgress.EMPTY)).entries().size() == count);
    }

    protected static SnapshotInfo assertSuccessful(ActionFuture<CreateSnapshotResponse> future) throws Exception {
        SnapshotInfo snapshotInfo = ((CreateSnapshotResponse)future.get()).getSnapshotInfo();
        AbstractSnapshotIntegTestCase.assertThat((Object)snapshotInfo.state(), (Matcher)Matchers.is((Object)SnapshotState.SUCCESS));
        return snapshotInfo;
    }

    protected void createIndexWithContent(String indexName) {
        this.createIndexWithContent(indexName, SINGLE_SHARD_NO_REPLICA);
    }

    protected void createIndexWithContent(String indexName, Settings indexSettings) {
        this.logger.info("--> creating index [{}]", (Object)indexName);
        this.createIndex(indexName, indexSettings);
        this.ensureGreen(indexName);
        this.index(indexName, "_doc", "some_id", "foo", "bar");
    }

    protected ActionFuture<AcknowledgedResponse> startDeleteSnapshot(String repoName, String snapshotName) {
        this.logger.info("--> deleting snapshot [{}] from repo [{}]", (Object)snapshotName, (Object)repoName);
        return this.clusterAdmin().prepareDeleteSnapshot(repoName, new String[]{snapshotName}).execute();
    }

    protected void updateClusterState(final Function<ClusterState, ClusterState> updater) throws Exception {
        final PlainActionFuture future = PlainActionFuture.newFuture();
        ClusterService clusterService = AbstractSnapshotIntegTestCase.internalCluster().getCurrentMasterNodeInstance(ClusterService.class);
        clusterService.submitStateUpdateTask("test", (ClusterStateTaskConfig)new ClusterStateUpdateTask(){

            public ClusterState execute(ClusterState currentState) {
                return (ClusterState)updater.apply(currentState);
            }

            public void onFailure(String source, Exception e) {
                future.onFailure(e);
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                future.onResponse(null);
            }
        });
        future.get();
    }

    protected SnapshotInfo getSnapshot(String repository, String snapshot) {
        List snapshotInfos = ((GetSnapshotsResponse)this.clusterAdmin().prepareGetSnapshots(repository).setSnapshots(new String[]{snapshot}).get()).getSnapshots();
        AbstractSnapshotIntegTestCase.assertThat((Object)snapshotInfos, (Matcher)Matchers.hasSize((int)1));
        return (SnapshotInfo)snapshotInfos.get(0);
    }

    protected void awaitMasterFinishRepoOperations() throws Exception {
        this.logger.info("--> waiting for master to finish all repo operations on its SNAPSHOT pool");
        ThreadPool masterThreadPool = AbstractSnapshotIntegTestCase.internalCluster().getMasterNodeInstance(ThreadPool.class);
        AbstractSnapshotIntegTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            for (ThreadPoolStats.Stats stat : masterThreadPool.stats()) {
                if (!"snapshot".equals(stat.getName())) continue;
                AbstractSnapshotIntegTestCase.assertEquals((long)stat.getActive(), (long)0L);
                break;
            }
        }));
    }
}

