/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.NodeRoleSettings;

public class NodeRoles {
    public static Settings onlyRole(DiscoveryNodeRole role) {
        return NodeRoles.onlyRole(Settings.EMPTY, role);
    }

    public static Settings onlyRole(Settings settings, DiscoveryNodeRole role) {
        return NodeRoles.onlyRoles(settings, Collections.singleton(role));
    }

    public static Settings onlyRoles(Set<DiscoveryNodeRole> roles) {
        return NodeRoles.onlyRoles(Settings.EMPTY, roles);
    }

    public static Settings onlyRoles(Settings settings, Set<DiscoveryNodeRole> roles) {
        return Settings.builder().put(settings).putList(NodeRoleSettings.NODE_ROLES_SETTING.getKey(), Collections.unmodifiableList(roles.stream().map(DiscoveryNodeRole::roleName).collect(Collectors.toList()))).build();
    }

    public static Settings removeRoles(Set<DiscoveryNodeRole> roles) {
        return NodeRoles.removeRoles(Settings.EMPTY, roles);
    }

    public static Settings removeRoles(Settings settings, Set<DiscoveryNodeRole> roles) {
        Settings.Builder builder = Settings.builder().put(settings);
        builder.putList(NodeRoleSettings.NODE_ROLES_SETTING.getKey(), Collections.unmodifiableList(((List)NodeRoleSettings.NODE_ROLES_SETTING.get(settings)).stream().filter(r -> !roles.contains(r)).map(DiscoveryNodeRole::roleName).collect(Collectors.toList())));
        return builder.build();
    }

    public static Settings addRoles(Set<DiscoveryNodeRole> roles) {
        return NodeRoles.addRoles(Settings.EMPTY, roles);
    }

    public static Settings addRoles(Settings settings, Set<DiscoveryNodeRole> roles) {
        Settings.Builder builder = Settings.builder().put(settings);
        builder.putList(NodeRoleSettings.NODE_ROLES_SETTING.getKey(), Collections.unmodifiableList(Stream.concat(((List)NodeRoleSettings.NODE_ROLES_SETTING.get(settings)).stream(), roles.stream()).map(DiscoveryNodeRole::roleName).distinct().collect(Collectors.toList())));
        return builder.build();
    }

    public static Settings noRoles() {
        return NodeRoles.noRoles(Settings.EMPTY);
    }

    public static Settings noRoles(Settings settings) {
        return Settings.builder().put(settings).putList(NodeRoleSettings.NODE_ROLES_SETTING.getKey(), Collections.emptyList()).build();
    }

    public static Settings dataNode() {
        return NodeRoles.dataNode(Settings.EMPTY);
    }

    public static Settings dataNode(Settings settings) {
        return NodeRoles.addRoles(settings, Collections.singleton(DiscoveryNodeRole.DATA_ROLE));
    }

    public static Settings dataOnlyNode() {
        return NodeRoles.dataOnlyNode(Settings.EMPTY);
    }

    public static Settings dataOnlyNode(Settings settings) {
        return NodeRoles.onlyRole(settings, DiscoveryNodeRole.DATA_ROLE);
    }

    public static Settings nonDataNode() {
        return NodeRoles.nonDataNode(Settings.EMPTY);
    }

    public static Settings nonDataNode(Settings settings) {
        return NodeRoles.removeRoles(settings, Collections.singleton(DiscoveryNodeRole.DATA_ROLE));
    }

    public static Settings ingestNode() {
        return NodeRoles.ingestNode(Settings.EMPTY);
    }

    public static Settings ingestNode(Settings settings) {
        return NodeRoles.addRoles(settings, Collections.singleton(DiscoveryNodeRole.INGEST_ROLE));
    }

    public static Settings ingestOnlyNode() {
        return NodeRoles.ingestOnlyNode(Settings.EMPTY);
    }

    public static Settings ingestOnlyNode(Settings settings) {
        return NodeRoles.onlyRole(settings, DiscoveryNodeRole.INGEST_ROLE);
    }

    public static Settings nonIngestNode() {
        return NodeRoles.nonIngestNode(Settings.EMPTY);
    }

    public static Settings nonIngestNode(Settings settings) {
        return NodeRoles.removeRoles(settings, Collections.singleton(DiscoveryNodeRole.INGEST_ROLE));
    }

    public static Settings masterNode() {
        return NodeRoles.masterNode(Settings.EMPTY);
    }

    public static Settings masterNode(Settings settings) {
        return NodeRoles.addRoles(settings, Collections.singleton(DiscoveryNodeRole.MASTER_ROLE));
    }

    public static Settings masterOnlyNode() {
        return NodeRoles.masterOnlyNode(Settings.EMPTY);
    }

    public static Settings masterOnlyNode(Settings settings) {
        return NodeRoles.onlyRole(settings, DiscoveryNodeRole.MASTER_ROLE);
    }

    public static Settings nonMasterNode() {
        return NodeRoles.nonMasterNode(Settings.EMPTY);
    }

    public static Settings nonMasterNode(Settings settings) {
        return NodeRoles.removeRoles(settings, Collections.singleton(DiscoveryNodeRole.MASTER_ROLE));
    }

    public static Settings remoteClusterClientNode() {
        return NodeRoles.remoteClusterClientNode(Settings.EMPTY);
    }

    public static Settings remoteClusterClientNode(Settings settings) {
        return NodeRoles.addRoles(settings, Collections.singleton(DiscoveryNodeRole.REMOTE_CLUSTER_CLIENT_ROLE));
    }

    public static Settings nonRemoteClusterClientNode() {
        return NodeRoles.nonRemoteClusterClientNode(Settings.EMPTY);
    }

    public static Settings nonRemoteClusterClientNode(Settings settings) {
        return NodeRoles.removeRoles(settings, Collections.singleton(DiscoveryNodeRole.REMOTE_CLUSTER_CLIENT_ROLE));
    }
}

