/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.rest.AbstractRestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public final class FakeRestChannel
extends AbstractRestChannel {
    private final CountDownLatch latch;
    private final AtomicInteger responses = new AtomicInteger();
    private final AtomicInteger errors = new AtomicInteger();
    private RestResponse capturedRestResponse;

    public FakeRestChannel(RestRequest request, boolean detailedErrorsEnabled, int responseCount) {
        super(request, detailedErrorsEnabled);
        this.latch = new CountDownLatch(responseCount);
    }

    public void sendResponse(RestResponse response) {
        this.capturedRestResponse = response;
        if (response.status() == RestStatus.OK) {
            this.responses.incrementAndGet();
        } else {
            this.errors.incrementAndGet();
        }
        this.latch.countDown();
    }

    public RestResponse capturedResponse() {
        return this.capturedRestResponse;
    }

    public AtomicInteger responses() {
        return this.responses;
    }

    public AtomicInteger errors() {
        return this.errors;
    }
}

