/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.store;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.plugins.IndexStorePlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.test.store.MockFSDirectoryFactory;

public final class MockFSIndexStore {
    public static final Setting<Boolean> INDEX_CHECK_INDEX_ON_CLOSE_SETTING = Setting.boolSetting((String)"index.store.mock.check_index_on_close", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.NodeScope});
    private static final EnumSet<IndexShardState> validCheckIndexStates = EnumSet.of(IndexShardState.STARTED, IndexShardState.POST_RECOVERY);

    private static final class Listener
    implements IndexEventListener {
        private final Map<IndexShard, Boolean> shardSet = Collections.synchronizedMap(new IdentityHashMap());

        private Listener() {
        }

        public void afterIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, Settings indexSettings) {
            Boolean remove;
            if (indexShard != null && (remove = this.shardSet.remove(indexShard)) == Boolean.TRUE) {
                Logger logger = Loggers.getLogger(this.getClass(), (ShardId)indexShard.shardId(), (String[])new String[0]);
                MockFSDirectoryFactory.checkIndex(logger, indexShard.store(), indexShard.shardId());
            }
        }

        public void indexShardStateChanged(IndexShard indexShard, @Nullable IndexShardState previousState, IndexShardState currentState, @Nullable String reason) {
            if (currentState == IndexShardState.CLOSED && validCheckIndexStates.contains(previousState)) {
                this.shardSet.put(indexShard, Boolean.TRUE);
            }
        }
    }

    public static class TestPlugin
    extends Plugin
    implements IndexStorePlugin {
        public Settings additionalSettings() {
            return Settings.builder().put(IndexModule.INDEX_STORE_TYPE_SETTING.getKey(), "mock").build();
        }

        public List<Setting<?>> getSettings() {
            return Arrays.asList(INDEX_CHECK_INDEX_ON_CLOSE_SETTING, MockFSDirectoryFactory.CRASH_INDEX_SETTING, MockFSDirectoryFactory.RANDOM_IO_EXCEPTION_RATE_SETTING, MockFSDirectoryFactory.RANDOM_IO_EXCEPTION_RATE_ON_OPEN_SETTING);
        }

        public Map<String, IndexStorePlugin.DirectoryFactory> getDirectoryFactories() {
            return Collections.singletonMap("mock", new MockFSDirectoryFactory());
        }

        public void onIndexModule(IndexModule indexModule) {
            Settings indexSettings = indexModule.getSettings();
            if ("mock".equals(indexSettings.get(IndexModule.INDEX_STORE_TYPE_SETTING.getKey())) && ((Boolean)INDEX_CHECK_INDEX_ON_CLOSE_SETTING.get(indexSettings)).booleanValue()) {
                indexModule.addIndexEventListener((IndexEventListener)new Listener());
            }
        }
    }
}

