/*
 * Decompiled with CFR 0.152.
 */
package org.eluder.coveralls.maven.plugin;

import java.util.Properties;
import org.codehaus.plexus.util.StringUtils;
import org.eluder.coveralls.maven.plugin.CoverallsReportMojo;
import org.eluder.coveralls.maven.plugin.service.ServiceSetup;

public final class Environment {
    private final CoverallsReportMojo mojo;
    private final Iterable<ServiceSetup> services;

    public Environment(CoverallsReportMojo mojo, Iterable<ServiceSetup> services) {
        if (mojo == null) {
            throw new IllegalArgumentException("mojo must be defined");
        }
        if (services == null) {
            throw new IllegalArgumentException("services must be defined");
        }
        this.mojo = mojo;
        this.services = services;
    }

    public void setup() {
        this.setupService();
        this.verify();
    }

    private void verify() {
        if (this.mojo.sourceEncoding == null) {
            throw new IllegalArgumentException("Source encoding not set, use <sourceEncoding> configuration option or set project wide property <project.build.sourceEncoding>");
        }
    }

    private void setupService() {
        for (ServiceSetup service : this.services) {
            if (!service.isSelected()) continue;
            this.setupEnvironment(service);
            break;
        }
    }

    private void setupEnvironment(ServiceSetup service) {
        String name = service.getName();
        if (StringUtils.isBlank((String)this.mojo.serviceName) && StringUtils.isNotBlank((String)name)) {
            this.mojo.serviceName = name;
        }
        String jobId = service.getJobId();
        if (StringUtils.isBlank((String)this.mojo.serviceJobId) && StringUtils.isNotBlank((String)jobId)) {
            this.mojo.serviceJobId = jobId;
        }
        String buildNumber = service.getBuildNumber();
        if (StringUtils.isBlank((String)this.mojo.serviceBuildNumber) && StringUtils.isNotBlank((String)buildNumber)) {
            this.mojo.serviceBuildNumber = buildNumber;
        }
        String buildUrl = service.getBuildUrl();
        if (StringUtils.isBlank((String)this.mojo.serviceBuildUrl) && StringUtils.isNotBlank((String)buildUrl)) {
            this.mojo.serviceBuildUrl = buildUrl;
        }
        String branch = service.getBranch();
        if (StringUtils.isBlank((String)this.mojo.branch) && StringUtils.isNotBlank((String)branch)) {
            this.mojo.branch = branch;
        }
        String pullRequest = service.getPullRequest();
        if (StringUtils.isBlank((String)this.mojo.pullRequest) && StringUtils.isNotBlank((String)pullRequest)) {
            this.mojo.pullRequest = pullRequest;
        }
        Properties environment = service.getEnvironment();
        if ((this.mojo.serviceEnvironment == null || this.mojo.serviceEnvironment.isEmpty()) && environment != null && !environment.isEmpty()) {
            this.mojo.serviceEnvironment = environment;
        }
    }
}

