/*
 * Decompiled with CFR 0.152.
 */
package org.eluder.coveralls.maven.plugin.httpclient;

import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.maven.settings.Proxy;
import org.codehaus.plexus.util.StringUtils;
import org.eluder.coveralls.maven.plugin.util.UrlUtils;
import org.eluder.coveralls.maven.plugin.util.Wildcards;

class HttpClientFactory {
    private static final int DEFAULT_CONNECTION_TIMEOUT = 10000;
    private static final int DEFAULT_SOCKET_TIMEOUT = 60000;
    private final String targetUrl;
    private final HttpClientBuilder hcb = HttpClientBuilder.create();
    private final RequestConfig.Builder rcb = RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(60000);

    HttpClientFactory(String targetUrl) {
        this.targetUrl = targetUrl;
    }

    public HttpClientFactory proxy(Proxy proxy) {
        if (proxy != null && this.isProxied(this.targetUrl, proxy)) {
            this.rcb.setProxy(new HttpHost(proxy.getHost(), proxy.getPort(), proxy.getProtocol()));
            if (StringUtils.isNotBlank((String)proxy.getUsername())) {
                BasicCredentialsProvider cp = new BasicCredentialsProvider();
                cp.setCredentials(new AuthScope(proxy.getHost(), proxy.getPort()), (Credentials)new UsernamePasswordCredentials(proxy.getUsername(), proxy.getPassword()));
                this.hcb.setDefaultCredentialsProvider((CredentialsProvider)cp);
            }
        }
        return this;
    }

    public HttpClient create() {
        return this.hcb.setDefaultRequestConfig(this.rcb.build()).build();
    }

    private boolean isProxied(String url, Proxy proxy) {
        if (StringUtils.isNotBlank((String)proxy.getNonProxyHosts())) {
            String[] excludes;
            String host = UrlUtils.create(url).getHost();
            for (String exclude : excludes = proxy.getNonProxyHosts().split("\\|")) {
                if (!StringUtils.isNotBlank((String)exclude) || !Wildcards.matches(host, exclude.trim())) continue;
                return false;
            }
        }
        return true;
    }
}

