/*
 * Decompiled with CFR 0.152.
 */
package org.eluder.coveralls.maven.plugin.source;

import java.io.IOException;
import org.eluder.coveralls.maven.plugin.ProcessingException;
import org.eluder.coveralls.maven.plugin.domain.Source;
import org.eluder.coveralls.maven.plugin.source.SourceCallback;

public abstract class ChainingSourceCallback
implements SourceCallback {
    private final SourceCallback chained;

    public ChainingSourceCallback(SourceCallback chained) {
        if (chained == null) {
            throw new IllegalArgumentException("chained must be defined");
        }
        this.chained = chained;
    }

    @Override
    public final void onBegin() throws ProcessingException, IOException {
        this.onBeginInternal();
        this.chained.onBegin();
    }

    @Override
    public final void onSource(Source source) throws ProcessingException, IOException {
        this.onSourceInternal(source);
        this.chained.onSource(source);
    }

    @Override
    public final void onComplete() throws ProcessingException, IOException {
        this.onCompleteInternal();
        this.chained.onComplete();
    }

    protected void onBeginInternal() throws ProcessingException, IOException {
    }

    protected abstract void onSourceInternal(Source var1) throws ProcessingException, IOException;

    protected void onCompleteInternal() throws ProcessingException, IOException {
    }
}

