/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.json.schema.ObjectComparator;
import org.everit.json.schema.Schema;
import org.everit.json.schema.SchemaException;
import org.everit.json.schema.ValidationException;
import org.json.JSONArray;

public class ArraySchema
extends Schema {
    private final Integer minItems;
    private final Integer maxItems;
    private final boolean uniqueItems;
    private final Schema allItemSchema;
    private final boolean additionalItems;
    private final List<Schema> itemSchemas;
    private final boolean requiresArray;
    private final Schema schemaOfAdditionalItems;

    public static Builder builder() {
        return new Builder();
    }

    public ArraySchema(Builder builder) {
        super(builder);
        this.minItems = builder.minItems;
        this.maxItems = builder.maxItems;
        this.uniqueItems = builder.uniqueItems;
        this.allItemSchema = builder.allItemSchema;
        this.itemSchemas = builder.itemSchemas;
        this.additionalItems = !builder.additionalItems && this.allItemSchema != null ? true : builder.schemaOfAdditionalItems != null || builder.additionalItems;
        this.schemaOfAdditionalItems = builder.schemaOfAdditionalItems;
        if (this.allItemSchema != null && this.itemSchemas != null) {
            throw new SchemaException("cannot perform both tuple and list validation");
        }
        this.requiresArray = builder.requiresArray;
    }

    public Schema getAllItemSchema() {
        return this.allItemSchema;
    }

    public List<Schema> getItemSchemas() {
        return this.itemSchemas;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public Integer getMinItems() {
        return this.minItems;
    }

    public boolean needsUniqueItems() {
        return this.uniqueItems;
    }

    public boolean permitsAdditionalItems() {
        return this.additionalItems;
    }

    private void testItemCount(JSONArray subject) {
        int actualLength = subject.length();
        if (this.minItems != null && actualLength < this.minItems) {
            throw new ValidationException("expected minimum item count: " + this.minItems + ", found: " + actualLength);
        }
        if (this.maxItems != null && this.maxItems < actualLength) {
            throw new ValidationException("expected maximum item count: " + this.minItems + ", found: " + actualLength);
        }
    }

    private void testItems(JSONArray subject) {
        block6: {
            int i;
            block5: {
                if (this.allItemSchema == null) break block5;
                for (int i2 = 0; i2 < subject.length(); ++i2) {
                    this.allItemSchema.validate(subject.get(i2));
                }
                break block6;
            }
            if (this.itemSchemas == null) break block6;
            if (!this.additionalItems && subject.length() > this.itemSchemas.size()) {
                throw new ValidationException(String.format("expected: [%d] array items, found: [%d]", this.itemSchemas.size(), subject.length()));
            }
            int itemValidationUntil = Math.min(subject.length(), this.itemSchemas.size());
            for (i = 0; i < itemValidationUntil; ++i) {
                this.itemSchemas.get(i).validate(subject.get(i));
            }
            if (this.schemaOfAdditionalItems != null) {
                for (i = itemValidationUntil; i < subject.length(); ++i) {
                    this.schemaOfAdditionalItems.validate(subject.get(i));
                }
            }
        }
    }

    private void testUniqueness(JSONArray subject) {
        if (subject.length() == 0) {
            return;
        }
        ArrayList<Object> uniqueItems = new ArrayList<Object>(subject.length());
        for (int i = 0; i < subject.length(); ++i) {
            Object item = subject.get(i);
            for (Object e : uniqueItems) {
                if (!ObjectComparator.deepEquals(e, item)) continue;
                throw new ValidationException("array items are not unique");
            }
            uniqueItems.add(item);
        }
    }

    @Override
    public void validate(Object subject) {
        if (!(subject instanceof JSONArray)) {
            if (this.requiresArray) {
                throw new ValidationException(JSONArray.class, subject);
            }
        } else {
            JSONArray arrSubject = (JSONArray)subject;
            this.testItemCount(arrSubject);
            if (this.uniqueItems) {
                this.testUniqueness(arrSubject);
            }
            this.testItems(arrSubject);
        }
    }

    public boolean requiresArray() {
        return this.requiresArray;
    }

    public Schema getSchemaOfAdditionalItems() {
        return this.schemaOfAdditionalItems;
    }

    public static class Builder
    extends Schema.Builder<ArraySchema> {
        private boolean requiresArray = true;
        private Integer minItems;
        private Integer maxItems;
        private boolean uniqueItems = false;
        private Schema allItemSchema;
        private List<Schema> itemSchemas = null;
        private boolean additionalItems = true;
        private Schema schemaOfAdditionalItems;

        public Builder addItemSchema(Schema itemSchema) {
            if (this.itemSchemas == null) {
                this.itemSchemas = new ArrayList<Schema>();
            }
            this.itemSchemas.add(Objects.requireNonNull(itemSchema, "itemSchema cannot be null"));
            return this;
        }

        public Builder schemaOfAdditionalItems(Schema schemaOfAdditionalItems) {
            this.schemaOfAdditionalItems = schemaOfAdditionalItems;
            return this;
        }

        public Builder requiresArray(boolean requiresArray) {
            this.requiresArray = requiresArray;
            return this;
        }

        public Builder additionalItems(boolean additionalItems) {
            this.additionalItems = additionalItems;
            return this;
        }

        public Builder allItemSchema(Schema allItemSchema) {
            this.allItemSchema = allItemSchema;
            return this;
        }

        @Override
        public ArraySchema build() {
            return new ArraySchema(this);
        }

        public Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public Builder minItems(Integer minItems) {
            this.minItems = minItems;
            return this;
        }

        public Builder uniqueItems(boolean uniqueItems) {
            this.uniqueItems = uniqueItems;
            return this;
        }
    }
}

