/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.everit.json.schema.ObjectComparator;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;

public class EnumSchema
extends Schema {
    private final Set<Object> possibleValues;

    public EnumSchema(Builder builder) {
        super(builder);
        this.possibleValues = Collections.unmodifiableSet(new HashSet(builder.possibleValues));
    }

    @Override
    public void validate(Object subject) {
        this.possibleValues.stream().filter(val -> ObjectComparator.deepEquals(val, subject)).findAny().orElseThrow(() -> new ValidationException(String.format("%s is not a valid enum value", subject)));
    }

    public Set<Object> getPossibleValues() {
        return this.possibleValues;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Schema.Builder<EnumSchema> {
        private Set<Object> possibleValues = new HashSet<Object>();

        public Builder possibleValue(Object possibleValue) {
            this.possibleValues.add(possibleValue);
            return this;
        }

        public Builder possibleValues(Set<Object> possibleValues) {
            this.possibleValues = possibleValues;
            return this;
        }

        @Override
        public EnumSchema build() {
            return new EnumSchema(this);
        }
    }
}

