/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.everit.json.schema.Schema;
import org.everit.json.schema.SchemaException;
import org.everit.json.schema.ValidationException;
import org.json.JSONObject;

public class ObjectSchema
extends Schema {
    private final Map<String, Schema> propertySchemas;
    private final boolean additionalProperties;
    private final Schema schemaOfAdditionalProperties;
    private final List<String> requiredProperties;
    private final Integer minProperties;
    private final Integer maxProperties;
    private final Map<String, Set<String>> propertyDependencies;
    private final Map<String, Schema> schemaDependencies;
    private final boolean requiresObject;
    private final Map<Pattern, Schema> patternProperties;

    public static Builder builder() {
        return new Builder();
    }

    public ObjectSchema(Builder builder) {
        super(builder);
        this.propertySchemas = builder.propertySchemas == null ? null : Collections.unmodifiableMap(builder.propertySchemas);
        this.additionalProperties = builder.additionalProperties;
        this.schemaOfAdditionalProperties = builder.schemaOfAdditionalProperties;
        if (!this.additionalProperties && this.schemaOfAdditionalProperties != null) {
            throw new SchemaException("additionalProperties cannot be false if schemaOfAdditionalProperties is present");
        }
        this.requiredProperties = Collections.unmodifiableList(new ArrayList(builder.requiredProperties));
        this.minProperties = builder.minProperties;
        this.maxProperties = builder.maxProperties;
        this.propertyDependencies = Collections.unmodifiableMap(builder.propertyDependencies);
        this.schemaDependencies = Collections.unmodifiableMap(builder.schemaDependencies);
        this.requiresObject = builder.requiresObject;
        this.patternProperties = Collections.unmodifiableMap(builder.patternProperties);
    }

    private void failure(String exceptionMessage, Object ... params) {
        throw new ValidationException(String.format(exceptionMessage, params));
    }

    public Integer getMaxProperties() {
        return this.maxProperties;
    }

    public Integer getMinProperties() {
        return this.minProperties;
    }

    public Map<String, Set<String>> getPropertyDependencies() {
        return this.propertyDependencies;
    }

    public Map<String, Schema> getPropertySchemas() {
        return this.propertySchemas;
    }

    public List<String> getRequiredProperties() {
        return this.requiredProperties;
    }

    public Map<String, Schema> getSchemaDependencies() {
        return this.schemaDependencies;
    }

    public Schema getSchemaOfAdditionalProperties() {
        return this.schemaOfAdditionalProperties;
    }

    public boolean permitsAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean matchesAnyPattern(String key) {
        return this.patternProperties.keySet().stream().filter(pattern -> pattern.matcher(key).find()).findAny().isPresent();
    }

    private void testAdditionalProperties(JSONObject subject) {
        if (!this.additionalProperties) {
            this.getAdditionalProperties(subject).findFirst().ifPresent(unneeded -> this.failure("extraneous key [%s] is not permitted", unneeded));
        } else if (this.schemaOfAdditionalProperties != null) {
            this.getAdditionalProperties(subject).map(arg_0 -> ((JSONObject)subject).get(arg_0)).forEach(this.schemaOfAdditionalProperties::validate);
        }
    }

    private Stream<String> getAdditionalProperties(JSONObject subject) {
        return Arrays.stream(JSONObject.getNames((JSONObject)subject)).filter(key -> !this.propertySchemas.containsKey(key)).filter(key -> !this.matchesAnyPattern((String)key));
    }

    private void testProperties(JSONObject subject) {
        if (this.propertySchemas != null) {
            for (Map.Entry<String, Schema> entry : this.propertySchemas.entrySet()) {
                String key = entry.getKey();
                if (!subject.has(key)) continue;
                entry.getValue().validate(subject.get(key));
            }
        }
    }

    private void testPropertyDependencies(JSONObject subject) {
        this.propertyDependencies.keySet().stream().filter(arg_0 -> ((JSONObject)subject).has(arg_0)).flatMap(ifPresent -> this.propertyDependencies.get(ifPresent).stream()).filter(mustBePresent -> !subject.has(mustBePresent)).findFirst().ifPresent(missing -> this.failure("property [%s] is required", missing));
    }

    private void testRequiredProperties(JSONObject subject) {
        this.requiredProperties.stream().filter(key -> !subject.has(key)).findFirst().ifPresent(missing -> this.failure("required key [%s] not found", missing));
    }

    private void testSchemaDependencies(JSONObject subject) {
        this.schemaDependencies.keySet().stream().filter(arg_0 -> ((JSONObject)subject).has(arg_0)).map(this.schemaDependencies::get).forEach(schema -> schema.validate(subject));
    }

    private void testSize(JSONObject subject) {
        int actualSize = subject.length();
        if (this.minProperties != null && actualSize < this.minProperties) {
            throw new ValidationException(String.format("minimum size: [%d], found: [%d]", this.minProperties, actualSize));
        }
        if (this.maxProperties != null && actualSize > this.maxProperties) {
            throw new ValidationException(String.format("maximum size: [%d], found: [%d]", this.maxProperties, actualSize));
        }
    }

    @Override
    public void validate(Object subject) {
        if (!(subject instanceof JSONObject)) {
            if (this.requiresObject) {
                throw new ValidationException(JSONObject.class, subject);
            }
        } else {
            JSONObject objSubject = (JSONObject)subject;
            this.testProperties(objSubject);
            this.testRequiredProperties(objSubject);
            this.testAdditionalProperties(objSubject);
            this.testSize(objSubject);
            this.testPropertyDependencies(objSubject);
            this.testSchemaDependencies(objSubject);
            this.testPatternProperties(objSubject);
        }
    }

    private void testPatternProperties(JSONObject subject) {
        String[] propNames = JSONObject.getNames((JSONObject)subject);
        if (propNames == null || propNames.length == 0) {
            return;
        }
        for (Map.Entry<Pattern, Schema> entry : this.patternProperties.entrySet()) {
            for (String propName : propNames) {
                if (!entry.getKey().matcher(propName).find()) continue;
                entry.getValue().validate(subject.get(propName));
            }
        }
    }

    public boolean requiresObject() {
        return this.requiresObject;
    }

    public Map<Pattern, Schema> getPatternProperties() {
        return this.patternProperties;
    }

    public static class Builder
    extends Schema.Builder<ObjectSchema> {
        private final Map<Pattern, Schema> patternProperties = new HashMap<Pattern, Schema>();
        private boolean requiresObject = true;
        private final Map<String, Schema> propertySchemas = new HashMap<String, Schema>();
        private boolean additionalProperties = true;
        private Schema schemaOfAdditionalProperties;
        private final List<String> requiredProperties = new ArrayList<String>(0);
        private Integer minProperties;
        private Integer maxProperties;
        private final Map<String, Set<String>> propertyDependencies = new HashMap<String, Set<String>>();
        private final Map<String, Schema> schemaDependencies = new HashMap<String, Schema>();

        public Builder requiresObject(boolean requiresObject) {
            this.requiresObject = requiresObject;
            return this;
        }

        public Builder additionalProperties(boolean additionalProperties) {
            this.additionalProperties = additionalProperties;
            return this;
        }

        public Builder patternProperty(Pattern pattern, Schema schema) {
            this.patternProperties.put(pattern, schema);
            return this;
        }

        public Builder patternProperty(String pattern, Schema schema) {
            return this.patternProperty(Pattern.compile(pattern), schema);
        }

        public Builder addPropertySchema(String propName, Schema schema) {
            Objects.requireNonNull(propName, "propName cannot be null");
            Objects.requireNonNull(schema, "schema cannot be null");
            this.propertySchemas.put(propName, schema);
            return this;
        }

        public Builder addRequiredProperty(String propertyName) {
            this.requiredProperties.add(propertyName);
            return this;
        }

        @Override
        public ObjectSchema build() {
            return new ObjectSchema(this);
        }

        public Builder maxProperties(Integer maxProperties) {
            this.maxProperties = maxProperties;
            return this;
        }

        public Builder minProperties(Integer minProperties) {
            this.minProperties = minProperties;
            return this;
        }

        public Builder propertyDependency(String ifPresent, String mustBePresent) {
            Set<String> dependencies = this.propertyDependencies.get(ifPresent);
            if (dependencies == null) {
                dependencies = new HashSet<String>(1);
                this.propertyDependencies.put(ifPresent, dependencies);
            }
            dependencies.add(mustBePresent);
            return this;
        }

        public Builder schemaDependency(String ifPresent, Schema expectedSchema) {
            this.schemaDependencies.put(ifPresent, expectedSchema);
            return this;
        }

        public Builder schemaOfAdditionalProperties(Schema schemaOfAdditionalProperties) {
            this.schemaOfAdditionalProperties = schemaOfAdditionalProperties;
            return this;
        }
    }
}

