/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.client;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.fakereplace.client.ClassData;
import org.fakereplace.client.ResourceData;

public class FakeReplaceClient {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(String deploymentName, Map<String, ClassData> classes, Map<String, ResourceData> resources) throws IOException {
        Socket socket = new Socket("localhost", 6555);
        try {
            FakeReplaceClient.run(socket, deploymentName, classes, resources);
        }
        finally {
            socket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(Socket socket, String deploymentName, Map<String, ClassData> classes, Map<String, ResourceData> resources) {
        try {
            byte[] bytes;
            Object data;
            DataInputStream input = new DataInputStream(socket.getInputStream());
            DataOutputStream output = new DataOutputStream(socket.getOutputStream());
            output.writeInt(-889266513);
            output.writeInt(deploymentName.length());
            output.write(deploymentName.getBytes());
            output.writeInt(classes.size());
            for (Map.Entry<String, ClassData> entry : classes.entrySet()) {
                output.writeInt(entry.getKey().length());
                output.write(entry.getKey().getBytes());
                output.writeLong(entry.getValue().getTimestamp());
            }
            output.writeInt(resources.size());
            for (Map.Entry<String, Object> entry : resources.entrySet()) {
                ResourceData data2 = (ResourceData)entry.getValue();
                output.writeInt(data2.getRelativePath().length());
                output.write(data2.getRelativePath().getBytes());
                output.writeLong(data2.getTimestamp());
            }
            output.flush();
            HashSet<String> classNames = new HashSet<String>();
            HashSet<String> hashSet = new HashSet<String>();
            FakeReplaceClient.readReplacable(input, classNames);
            FakeReplaceClient.readReplacable(input, hashSet);
            if (classNames.isEmpty()) {
                System.out.println("No updated classes found to replace");
            } else {
                System.out.println("Updating " + classNames.size() + " classes");
            }
            output.flush();
            output.writeInt(classNames.size());
            for (String name : classNames) {
                data = classes.get(name);
                output.writeInt(name.length());
                output.write(name.getBytes());
                bytes = ((ClassData)data).getContentSource().getData();
                output.writeInt(bytes.length);
                output.write(bytes);
            }
            output.writeInt(hashSet.size());
            for (String resource : hashSet) {
                data = resources.get(resource);
                output.writeInt(resource.length());
                output.write(resource.getBytes());
                bytes = ((ResourceData)data).getContentSource().getData();
                output.writeInt(bytes.length);
                output.write(bytes);
            }
            output.flush();
            int result = input.readInt();
            if (result != 0) {
                System.out.println("Replacement failed");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void readReplacable(DataInputStream input, Set<String> resourceNames) throws IOException {
        int noResources = input.readInt();
        for (int i = 0; i < noResources; ++i) {
            String className = FakeReplaceClient.readString(input);
            resourceNames.add(className);
        }
    }

    private static String readString(DataInputStream input) throws IOException {
        int toread;
        byte[] buf = new byte[toread];
        int read = 0;
        for (toread = input.readInt(); toread > 0 && (read = input.read(buf, read, toread)) != -1; toread -= read) {
        }
        return new String(buf);
    }
}

