/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.fakereplace.AgentOption;

public class AgentOptions {
    private static volatile AgentOptions instance;
    private final Map<String, String> options;

    public AgentOptions(Map<String, String> options) {
        this.options = Collections.unmodifiableMap(options);
    }

    static void setup(String options) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (options != null) {
            String[] parts;
            for (String part : parts = options.split(",")) {
                int index = part.indexOf("=");
                if (index == -1) {
                    map.put(part, null);
                    continue;
                }
                map.put(part.substring(0, index), part.substring(index + 1));
            }
        }
        instance = new AgentOptions(map);
    }

    public static boolean set(AgentOption option) {
        return AgentOptions.instance.options.containsKey(option.getKey());
    }

    public static String getOption(AgentOption option) {
        if (instance == null) {
            throw new IllegalStateException("setup() not called");
        }
        return AgentOptions.instance.options.get(option.getKey());
    }
}

