/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace;

import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.fakereplace.BuiltinClassData;
import org.fakereplace.api.Extension;
import org.fakereplace.boot.DefaultEnvironment;
import org.fakereplace.data.BaseClassData;
import org.fakereplace.data.ClassDataStore;
import org.fakereplace.data.InstanceTracker;
import org.fakereplace.javassist.bytecode.AnnotationsAttribute;
import org.fakereplace.javassist.bytecode.BadBytecode;
import org.fakereplace.javassist.bytecode.Bytecode;
import org.fakereplace.javassist.bytecode.ClassFile;
import org.fakereplace.javassist.bytecode.CodeAttribute;
import org.fakereplace.javassist.bytecode.CodeIterator;
import org.fakereplace.javassist.bytecode.DuplicateMemberException;
import org.fakereplace.javassist.bytecode.MethodInfo;
import org.fakereplace.javassist.bytecode.annotation.Annotation;
import org.fakereplace.manip.Manipulator;
import org.fakereplace.manip.util.ManipulationUtils;
import org.fakereplace.reflection.ReflectionInstrumentationSetup;
import org.fakereplace.transformation.FakereplaceTransformer;
import org.fakereplace.util.NoInstrument;

public class Transformer
implements FakereplaceTransformer {
    private static final Manipulator manipulator = new Manipulator();
    private final Set<String> trackedInstances = new HashSet<String>();
    private final List<FakereplaceTransformer> integrationTransformers = new CopyOnWriteArrayList<FakereplaceTransformer>();

    Transformer(Set<Extension> extension) {
        ReflectionInstrumentationSetup.setup(manipulator);
        for (Extension i : extension) {
            this.trackedInstances.addAll(i.getTrackedInstanceClassNames());
            FakereplaceTransformer t = i.getTransformer();
            if (t == null) continue;
            this.integrationTransformers.add(t);
        }
    }

    @Override
    public boolean transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, ClassFile file) throws IllegalClassFormatException {
        boolean modified = false;
        if (classBeingRedefined != null) {
            ClassDataStore.instance().markClassReplaced(classBeingRedefined);
        }
        try {
            boolean replaceable;
            Annotation an;
            AnnotationsAttribute at;
            for (FakereplaceTransformer i : this.integrationTransformers) {
                if (!i.transform(loader, className, classBeingRedefined, protectionDomain, file)) continue;
                modified = true;
            }
            if (BuiltinClassData.skipInstrumentation(className)) {
                if (classBeingRedefined != null && manipulator.transformClass(file, loader, false)) {
                    modified = true;
                }
                return modified;
            }
            if (classBeingRedefined == null && (at = (AnnotationsAttribute)file.getAttribute("RuntimeInvisibleAnnotations")) != null && (an = at.getAnnotation(NoInstrument.class.getName())) != null) {
                return modified;
            }
            if (this.trackedInstances.contains(file.getName())) {
                this.makeTrackedInstance(file);
                modified = true;
            }
            if (manipulator.transformClass(file, loader, replaceable = DefaultEnvironment.getEnvironment().isClassReplaceable(className, loader))) {
                modified = true;
            }
            if (replaceable) {
                if ((0x4000 & file.getAccessFlags()) == 0 && (0x2000 & file.getAccessFlags()) == 0) {
                    modified = true;
                    DefaultEnvironment.getEnvironment().recordTimestamp(className, loader);
                    if (file.isInterface()) {
                        this.addAbstractMethodForInstrumentation(file);
                    } else {
                        this.addMethodForInstrumentation(file);
                        this.addConstructorForInstrumentation(file);
                        Transformer.addStaticConstructorForInstrumentation(file);
                    }
                }
                BaseClassData baseData = new BaseClassData(file, loader, replaceable);
                ClassDataStore.instance().saveClassData(loader, baseData.getInternalName(), baseData);
            }
            return modified;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new IllegalClassFormatException();
        }
    }

    public void addMethodForInstrumentation(ClassFile file) {
        CodeAttribute ca;
        Bytecode b;
        MethodInfo m;
        try {
            m = new MethodInfo(file.getConstPool(), "______REDEFINED_METHOD_DELEGATOR_$", "(I[Ljava/lang/Object;)Ljava/lang/Object;");
            m.setAccessFlags(4097);
            b = new Bytecode(file.getConstPool(), 5, 3);
            if (BuiltinClassData.skipInstrumentation(file.getSuperclass())) {
                b.add(1);
                b.add(176);
            } else {
                b.add(42);
                b.add(27);
                b.add(44);
                b.addInvokespecial(file.getSuperclass(), "______REDEFINED_METHOD_DELEGATOR_$", "(I[Ljava/lang/Object;)Ljava/lang/Object;");
                b.add(176);
            }
            ca = b.toCodeAttribute();
            m.setCodeAttribute(ca);
            file.addMethod(m);
        }
        catch (DuplicateMemberException e) {
            // empty catch block
        }
        try {
            m = new MethodInfo(file.getConstPool(), "______REDEFINED_STATIC_METHOD_DELEGATOR_$", "(I[Ljava/lang/Object;)Ljava/lang/Object;");
            m.setAccessFlags(4105);
            b = new Bytecode(file.getConstPool(), 5, 3);
            b.add(1);
            b.add(176);
            ca = b.toCodeAttribute();
            m.setCodeAttribute(ca);
            file.addMethod(m);
        }
        catch (DuplicateMemberException duplicateMemberException) {
            // empty catch block
        }
    }

    public static void addStaticConstructorForInstrumentation(ClassFile file) {
        try {
            MethodInfo m = new MethodInfo(file.getConstPool(), "<clinit>", "()V");
            m.setAccessFlags(9);
            Bytecode b = new Bytecode(file.getConstPool());
            b.add(177);
            m.setCodeAttribute(b.toCodeAttribute());
            file.addMethod(m);
        }
        catch (DuplicateMemberException duplicateMemberException) {
            // empty catch block
        }
    }

    public void addAbstractMethodForInstrumentation(ClassFile file) {
        try {
            MethodInfo m = new MethodInfo(file.getConstPool(), "______REDEFINED_METHOD_DELEGATOR_$", "(I[Ljava/lang/Object;)Ljava/lang/Object;");
            m.setAccessFlags(5121);
            file.addMethod(m);
        }
        catch (DuplicateMemberException duplicateMemberException) {
            // empty catch block
        }
    }

    void addConstructorForInstrumentation(ClassFile file) {
        MethodInfo ret = new MethodInfo(file.getConstPool(), "<init>", "(I[Ljava/lang/Object;Lorg/fakereplace/ConstructorArgument;)V");
        Bytecode code = new Bytecode(file.getConstPool());
        if (!ManipulationUtils.addBogusConstructorCall(file, code)) {
            return;
        }
        CodeAttribute ca = code.toCodeAttribute();
        ca.setMaxLocals(4);
        ret.setCodeAttribute(ca);
        ret.setAccessFlags(4097);
        try {
            ca.computeMaxStack();
            file.addMethod(ret);
        }
        catch (DuplicateMemberException e) {
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Manipulator getManipulator() {
        return manipulator;
    }

    public void makeTrackedInstance(ClassFile file) throws BadBytecode {
        for (Object mo : file.getMethods()) {
            MethodInfo m = (MethodInfo)mo;
            if (!m.getName().equals("<init>")) continue;
            Bytecode code = new Bytecode(file.getConstPool());
            code.addLdc(file.getName());
            code.addAload(0);
            code.addInvokestatic(InstanceTracker.class.getName(), "add", "(Ljava/lang/String;Ljava/lang/Object;)V");
            CodeIterator it = m.getCodeAttribute().iterator();
            it.skipConstructor();
            it.insert(code.get());
        }
    }
}

