/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.api;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.fakereplace.api.ClassChangeAware;
import org.fakereplace.classloading.ClassIdentifier;
import org.fakereplace.com.google.common.collect.MapMaker;

public class ClassChangeNotifier {
    private static final ClassChangeNotifier INSTANCE = new ClassChangeNotifier();
    private static final ThreadLocal<Boolean> NOTIFICATION_IN_PROGRESS = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private final Map<ClassLoader, Set<ClassChangeAware>> classChangeAwares = new MapMaker().weakKeys().makeMap();

    public void add(ClassChangeAware aware) {
        if (!this.classChangeAwares.containsKey(aware.getClass().getClassLoader())) {
            this.classChangeAwares.put(aware.getClass().getClassLoader(), new HashSet());
        }
        this.classChangeAwares.get(aware.getClass().getClassLoader()).add(aware);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(Class<?>[] changed, ClassIdentifier[] newClasses) {
        if (!NOTIFICATION_IN_PROGRESS.get().booleanValue()) {
            NOTIFICATION_IN_PROGRESS.set(true);
            try {
                Class[] a = new Class[]{};
                for (Set<ClassChangeAware> c : this.classChangeAwares.values()) {
                    for (ClassChangeAware i : c) {
                        try {
                            i.notify(changed, newClasses);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            finally {
                NOTIFICATION_IN_PROGRESS.set(false);
            }
        }
    }

    public void beforeChange(Class<?>[] changed, ClassIdentifier[] newClasses) {
        Class[] a = new Class[]{};
        for (Set<ClassChangeAware> c : this.classChangeAwares.values()) {
            for (ClassChangeAware i : c) {
                try {
                    i.beforeChange(changed, newClasses);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    public static ClassChangeNotifier instance() {
        return INSTANCE;
    }
}

