/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.boot;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.fakereplace.AgentOption;
import org.fakereplace.AgentOptions;
import org.fakereplace.boot.Environment;
import org.fakereplace.logging.Logger;

public class DefaultEnvironment
implements Environment {
    private static final Logger log = Logger.getLogger(DefaultEnvironment.class);
    protected static final String[] replaceablePackages;
    protected static volatile Environment environment;
    private final Map<String, Long> timestamps = new ConcurrentHashMap<String, Long>();
    private final Map<String, ClassLoader> loaders = new ConcurrentHashMap<String, ClassLoader>();

    @Override
    public boolean isClassReplaceable(String className, ClassLoader loader) {
        URL u;
        for (String i : replaceablePackages) {
            if (!className.startsWith(i)) continue;
            return true;
        }
        if (className.contains("$Proxy")) {
            return true;
        }
        return loader != null && (u = loader.getResource(className.replace('.', '/') + ".class")) != null && (u.getProtocol().equals("file") || u.getProtocol().equals("vfsfile"));
    }

    public static Environment getEnvironment() {
        return environment;
    }

    public static void setEnvironment(Environment environment) {
        DefaultEnvironment.environment = environment;
    }

    @Override
    public void recordTimestamp(String className, ClassLoader loader) {
        log.trace("Recording timestamp for " + className);
        if (loader == null) {
            return;
        }
        URL file = loader.getResource(className.replace(".", "/") + ".class");
        className = className.replace("/", ".");
        if (file != null) {
            URLConnection connection = null;
            try {
                connection = file.openConnection();
                this.timestamps.put(className, connection.getLastModified());
                this.loaders.put(className, loader);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Set<Class> getUpdatedClasses(String deploymentName, Map<String, Long> updatedClasses) {
        HashSet<Class> ret = new HashSet<Class>();
        for (Map.Entry<String, Long> entry : updatedClasses.entrySet()) {
            if (!this.timestamps.containsKey(entry.getKey()) || this.timestamps.get(entry.getKey()) >= entry.getValue()) continue;
            ClassLoader loader = this.loaders.get(entry.getKey());
            try {
                ret.add(loader.loadClass(entry.getKey()));
                this.timestamps.put(entry.getKey(), entry.getValue());
            }
            catch (ClassNotFoundException e) {
                log.error("Could not load class " + entry, e);
            }
        }
        return ret;
    }

    @Override
    public Set<String> getUpdatedResources(String deploymentName, Map<String, Long> updatedResources) {
        return Collections.emptySet();
    }

    @Override
    public void updateResource(String archiveName, Map<String, byte[]> replacedResources) {
    }

    static {
        environment = new DefaultEnvironment();
        String plist = AgentOptions.getOption(AgentOption.PACKAGES);
        replaceablePackages = plist == null || plist.length() == 0 ? new String[0] : plist.split(";");
    }
}

