/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.integration.jsf;

import java.beans.Introspector;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import org.fakereplace.api.ClassChangeAware;
import org.fakereplace.classloading.ClassIdentifier;
import org.fakereplace.data.InstanceTracker;
import org.fakereplace.logging.Logger;

public class ClassRedefinitionPlugin
implements ClassChangeAware {
    private static final Logger log = Logger.getLogger(ClassRedefinitionPlugin.class);

    Field getField(Class<?> clazz, String name) throws NoSuchFieldException {
        if (clazz == Object.class) {
            throw new NoSuchFieldException();
        }
        try {
            return clazz.getDeclaredField(name);
        }
        catch (Exception exception) {
            return this.getField(clazz.getSuperclass(), name);
        }
    }

    @Override
    public void beforeChange(Class<?>[] changed, ClassIdentifier[] added) {
    }

    @Override
    public void notify(Class<?>[] changed, ClassIdentifier[] added) {
        try {
            Introspector.flushCaches();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Set<?> data = InstanceTracker.get("javax.el.BeanELResolver");
        for (Object i : data) {
            this.clearBeanElResolver(i);
        }
    }

    public void clearBeanElResolver(Object r) {
        try {
            try {
                Field cacheField = this.getField(r.getClass(), "cache");
                cacheField.setAccessible(true);
                Object cache = cacheField.get(r);
                try {
                    Method m = cache.getClass().getMethod("clear", new Class[0]);
                    m.invoke(cache, new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    Class<?> cacheClass = this.getClass().getClassLoader().loadClass("javax.el.BeanELResolver$ConcurrentCache");
                    Constructor<?> con = cacheClass.getConstructor(Integer.TYPE);
                    con.setAccessible(true);
                    Object cacheInstance = con.newInstance(100);
                    cacheField.set(r, cacheInstance);
                }
            }
            catch (NoSuchFieldException ee) {
                Field props = this.getField(r.getClass(), "properties");
                props.setAccessible(true);
                Object cache = props.get(r);
                Method m = cache.getClass().getMethod("clear", new Class[0]);
                m.invoke(cache, new Object[0]);
            }
        }
        catch (Exception e) {
            log.error("Could not clear EL cache:", e);
        }
    }
}

