/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.manip;

import java.util.Map;
import java.util.Set;
import org.fakereplace.javassist.bytecode.BadBytecode;
import org.fakereplace.javassist.bytecode.Bytecode;
import org.fakereplace.javassist.bytecode.ClassFile;
import org.fakereplace.javassist.bytecode.MethodInfo;
import org.fakereplace.manip.ClassManipulator;
import org.fakereplace.manip.data.SubclassVirtualCallData;
import org.fakereplace.manip.util.ManipulationDataStore;
import org.fakereplace.manip.util.ManipulationUtils;
import org.fakereplace.runtime.VirtualDelegator;
import org.fakereplace.util.DescriptorUtils;

public class SubclassVirtualCallManipulator
implements ClassManipulator {
    private final ManipulationDataStore<SubclassVirtualCallData> data = new ManipulationDataStore();

    public void addClassData(String className, ClassLoader classLoader, String parentClassName, ClassLoader parentClassLoader, String methodName, String methodDesc) {
        this.data.add(parentClassName, new SubclassVirtualCallData(parentClassLoader, parentClassName, methodName, methodDesc));
        VirtualDelegator.add(classLoader, className, methodName, methodDesc);
    }

    @Override
    public void clearRewrites(String className, ClassLoader classLoader) {
        VirtualDelegator.clear(classLoader, className);
    }

    @Override
    public boolean transformClass(ClassFile file, ClassLoader loader, boolean modifiableClass) {
        boolean modified = false;
        Map<String, Set<SubclassVirtualCallData>> loaderData = this.data.getManipulationData(loader);
        if (loaderData.containsKey(file.getName())) {
            Set<SubclassVirtualCallData> d = loaderData.get(file.getName());
            for (SubclassVirtualCallData s : d) {
                for (Object m : file.getMethods()) {
                    MethodInfo method = (MethodInfo)m;
                    if (!method.getName().equals(s.getMethodName()) || !method.getDescriptor().equals(s.getMethodDesc())) continue;
                    modified = true;
                    Bytecode run = new Bytecode(file.getConstPool());
                    run.add(42);
                    run.addLdc(method.getName());
                    run.addLdc(method.getDescriptor());
                    String[] params = DescriptorUtils.descriptorStringToParameterArray(method.getDescriptor());
                    int count = 1;
                    for (int i = 0; i < params.length; ++i) {
                        if (params[i].length() > 1) {
                            run.addAload(count);
                        } else if (params[i].equals("I") || params[i].equals("Z") || params[i].equals("S") || params[i].equals("B")) {
                            run.addIload(count);
                        } else if (params[i].equals("F")) {
                            run.addFload(count);
                        } else if (params[i].equals("J")) {
                            run.addLload(count);
                            ++count;
                        } else if (params[i].equals("D")) {
                            run.addDload(count);
                            ++count;
                        }
                        ++count;
                    }
                    ManipulationUtils.pushParametersIntoArray(run, method.getDescriptor());
                    run.addInvokestatic(VirtualDelegator.class.getName(), "run", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;");
                    ManipulationUtils.MethodReturnRewriter.addReturnProxyMethod(method.getDescriptor(), run);
                    Bytecode cd = new Bytecode(file.getConstPool());
                    cd.add(42);
                    cd.addLdc(file.getName());
                    cd.addLdc(method.getName());
                    cd.addLdc(method.getDescriptor());
                    cd.addInvokestatic(VirtualDelegator.class.getName(), "contains", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Z");
                    cd.add(153);
                    ManipulationUtils.add16bit(cd, run.getSize() + 3);
                    Bytecode b = new Bytecode(file.getConstPool());
                    b.add(42);
                    b.addInvokevirtual("java.lang.Object", "getClass", "()Ljava/lang/Class;");
                    b.addInvokevirtual("java.lang.Class", "getName", "()Ljava/lang/String;");
                    b.addLdc(file.getName());
                    b.addInvokevirtual("java.lang.Object", "equals", "(Ljava/lang/Object;)Z");
                    b.add(154);
                    ManipulationUtils.add16bit(b, run.getSize() + cd.getSize() + 3);
                    try {
                        method.getCodeAttribute().iterator().insert(run.get());
                        method.getCodeAttribute().iterator().insert(cd.get());
                        method.getCodeAttribute().iterator().insert(b.get());
                        method.getCodeAttribute().computeMaxStack();
                    }
                    catch (BadBytecode e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return modified;
    }
}

