/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.manip.util;

import org.fakereplace.data.MethodData;
import org.fakereplace.javassist.bytecode.BadBytecode;
import org.fakereplace.javassist.bytecode.Bytecode;
import org.fakereplace.javassist.bytecode.ClassFile;
import org.fakereplace.javassist.bytecode.CodeAttribute;
import org.fakereplace.javassist.bytecode.CodeIterator;
import org.fakereplace.javassist.bytecode.DuplicateMemberException;
import org.fakereplace.javassist.bytecode.MethodInfo;
import org.fakereplace.manip.util.Boxing;
import org.fakereplace.util.DescriptorUtils;

public class ManipulationUtils {
    private ManipulationUtils() {
    }

    public static boolean addBogusConstructorCall(ClassFile file, Bytecode code) {
        String[] params;
        MethodInfo constructorToCall = null;
        for (Object meth : file.getMethods()) {
            MethodInfo m = (MethodInfo)meth;
            if (!m.getName().equals("<init>")) continue;
            constructorToCall = m;
            break;
        }
        if (constructorToCall == null) {
            return false;
        }
        code.add(42);
        for (String p : params = DescriptorUtils.descriptorStringToParameterArray(constructorToCall.getDescriptor())) {
            if (p.equals("I") || p.equals("C") || p.equals("S") || p.equals("Z") || p.equals("B")) {
                code.add(3);
                continue;
            }
            if (p.equals("J")) {
                code.add(9);
                continue;
            }
            if (p.equals("D")) {
                code.add(14);
                continue;
            }
            if (p.equals("F")) {
                code.add(11);
                continue;
            }
            code.add(1);
        }
        code.addInvokespecial(file.getName(), "<init>", constructorToCall.getDescriptor());
        code.add(177);
        return true;
    }

    public static void add16bit(Bytecode b, int value) {
        b.add((value %= 65536) >> 8);
        b.add(value % 256);
    }

    public static void addDelegatingMethod(ClassFile file, MethodData mData) throws BadBytecode, DuplicateMemberException {
        MethodInfo m = new MethodInfo(file.getConstPool(), mData.getMethodName(), mData.getDescriptor());
        m.setAccessFlags(mData.getAccessFlags());
        Bytecode code = new Bytecode(file.getConstPool());
        String[] params = DescriptorUtils.descriptorStringToParameterArray(mData.getDescriptor());
        code.add(42);
        int count = 1;
        int maxLocals = 1;
        for (String p : params) {
            if (p.equals("I") || p.equals("C") || p.equals("S") || p.equals("Z") || p.equals("B")) {
                code.addIload(count);
                ++maxLocals;
            } else if (p.equals("J")) {
                code.addLload(count);
                maxLocals += 2;
                ++count;
            } else if (p.equals("D")) {
                code.addDload(count);
                maxLocals += 2;
                ++count;
            } else if (p.equals("F")) {
                code.addFload(count);
                ++maxLocals;
            } else {
                code.addAload(count);
                ++maxLocals;
            }
            ++count;
        }
        code.addInvokespecial(file.getSuperclass(), mData.getMethodName(), mData.getDescriptor());
        String p = DescriptorUtils.getReturnTypeInJvmFormat(mData.getDescriptor());
        if (p.equals("I") || p.equals("C") || p.equals("S") || p.equals("Z") || p.equals("B")) {
            code.add(172);
        } else if (p.equals("J")) {
            code.add(173);
        } else if (p.equals("D")) {
            code.add(175);
        } else if (p.equals("F")) {
            code.add(174);
        } else if (p.equals("V")) {
            code.add(177);
        } else {
            code.add(176);
        }
        CodeAttribute ca = code.toCodeAttribute();
        ca.computeMaxStack();
        ca.setMaxLocals(maxLocals);
        m.setCodeAttribute(ca);
        file.addMethod(m);
    }

    public static void pushParametersIntoArray(Bytecode bc, String methodDescriptor) {
        String[] params = DescriptorUtils.descriptorStringToParameterArray(methodDescriptor);
        bc.addIconst(params.length);
        bc.addAnewarray("java.lang.Object");
        for (int i = params.length - 1; i >= 0; --i) {
            if (DescriptorUtils.isWide(params[i])) {
                bc.add(91);
                bc.add(91);
                bc.add(87);
            } else {
                bc.add(90);
                bc.add(95);
            }
            if (DescriptorUtils.isPrimitive(params[i])) {
                Boxing.box(bc, params[i].charAt(0));
            }
            bc.addIconst(i);
            bc.add(95);
            bc.add(83);
        }
    }

    public static class MethodReturnRewriter {
        public static void rewriteFakeMethod(CodeIterator methodBody, String methodDescriptor) {
            String ret = DescriptorUtils.getReturnType(methodDescriptor);
            if (ret.length() != 1) {
                return;
            }
            byte ar = -80;
            byte[] areturn = new byte[]{ar};
            if (ret.equals("V")) {
                while (methodBody.hasNext()) {
                    try {
                        int index = methodBody.next();
                        int opcode = methodBody.byteAt(index);
                        if (opcode != 177) continue;
                        Bytecode code = new Bytecode(methodBody.get().getConstPool());
                        code.add(1);
                        code.add(176);
                        methodBody.insertAt(index, code.get());
                    }
                    catch (BadBytecode e) {
                        throw new RuntimeException(e);
                    }
                }
            } else {
                while (methodBody.hasNext()) {
                    try {
                        int index = methodBody.next();
                        int opcode = methodBody.byteAt(index);
                        switch (opcode) {
                            case 172: 
                            case 173: 
                            case 174: 
                            case 175: {
                                Bytecode b = new Bytecode(methodBody.get().getConstPool());
                                Boxing.box(b, ret.charAt(0));
                                b.addOpcode(176);
                                methodBody.insertAt(index, b.get());
                            }
                        }
                    }
                    catch (BadBytecode e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }

        public static void addReturnProxyMethod(String methodDescriptor, Bytecode b) {
            String ret = DescriptorUtils.getReturnType(methodDescriptor);
            if (ret.length() != 1) {
                b.addCheckcast(DescriptorUtils.getReturnTypeInJvmFormat(methodDescriptor));
                b.add(176);
                return;
            }
            if (ret.equals("V")) {
                b.add(177);
                return;
            }
            char tp = ret.charAt(0);
            Boxing.unbox(b, tp);
            if (tp == 'F') {
                b.add(174);
            } else if (tp == 'D') {
                b.add(175);
            } else if (tp == 'J') {
                b.add(173);
            } else {
                b.add(172);
            }
        }
    }
}

