/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.reflection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.fakereplace.data.ClassData;
import org.fakereplace.data.ClassDataStore;
import org.fakereplace.data.MemberType;
import org.fakereplace.data.MethodData;
import org.fakereplace.data.ModifiedMethod;
import org.fakereplace.javassist.bytecode.AccessFlag;
import org.fakereplace.javassist.bytecode.Descriptor;
import org.fakereplace.util.DescriptorUtils;
import sun.reflect.Reflection;

public class MethodReflection {
    public static int getModifiers(Method method) {
        if (method.isAnnotationPresent(ModifiedMethod.class)) {
            return method.getModifiers() | 0x10;
        }
        return method.getModifiers();
    }

    public static Object invoke(Method method, Object instance, Object[] args) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (!Modifier.isStatic(method.getModifiers())) {
            MethodData info = ClassDataStore.instance().getMethodInformation(method.getDeclaringClass().getName());
            try {
                Method invoke = info.getMethodToInvoke(method.getDeclaringClass());
                Object[] newAgrs = MethodReflection.prependInstanceToParams(instance, args);
                return MethodReflection.invokeWithPermissionCheck(method, invoke, null, newAgrs);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return MethodReflection.invokeWithPermissionCheck(method, method, instance, args);
    }

    private static Object invokeWithPermissionCheck(Method permissionCheckMethod, Method method, Object instance, Object[] params) throws IllegalAccessException, InvocationTargetException {
        if (!Modifier.isPublic(permissionCheckMethod.getModifiers()) && !permissionCheckMethod.isAccessible()) {
            Class caller = Reflection.getCallerClass((int)2);
            Reflection.ensureMemberAccess((Class)caller, permissionCheckMethod.getDeclaringClass(), null, (int)permissionCheckMethod.getModifiers());
            try {
                Method lookedUpMethod = method.getDeclaringClass().getDeclaredMethod(method.getName(), method.getParameterTypes());
                lookedUpMethod.setAccessible(true);
                return lookedUpMethod.invoke(instance, params);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
        return method.invoke(instance, params);
    }

    public static Method[] getDeclaredMethods(Class<?> clazz) {
        try {
            ClassData cd = ClassDataStore.instance().getModifiedClassData(clazz.getClassLoader(), Descriptor.toJvmName(clazz.getName()));
            if (cd == null || !cd.isReplaceable()) {
                return clazz.getDeclaredMethods();
            }
            Method[] meth = clazz.getDeclaredMethods();
            ArrayList<Method> visible = new ArrayList<Method>(meth.length);
            for (int i = 0; i < meth.length; ++i) {
                MethodData mData = cd.getData(meth[i]);
                if (mData != null && mData.getType() != MemberType.NORMAL) continue;
                visible.add(meth[i]);
            }
            for (MethodData i : cd.getMethods()) {
                if (i.getType() != MemberType.FAKE) continue;
                Class<?> c = clazz.getClassLoader().loadClass(i.getClassName());
                visible.add(i.getMethod(c));
            }
            Method[] ret = new Method[visible.size()];
            for (int i = 0; i < visible.size(); ++i) {
                ret[i] = (Method)visible.get(i);
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Method[] getMethods(Class<?> clazz) {
        try {
            ClassData cd = ClassDataStore.instance().getModifiedClassData(clazz.getClassLoader(), Descriptor.toJvmName(clazz.getName()));
            if (cd == null) {
                return clazz.getMethods();
            }
            Method[] meth = clazz.getMethods();
            ArrayList<Method> visible = new ArrayList<Method>(meth.length);
            for (int i = 0; i < meth.length; ++i) {
                MethodData mData = cd.getData(meth[i]);
                if (mData != null && mData.getType() != MemberType.NORMAL) continue;
                visible.add(meth[i]);
            }
            for (ClassData cta = cd; cta != null; cta = cta.getSuperClassInformation()) {
                if (!cta.isReplaceable()) continue;
                for (MethodData i : cta.getMethods()) {
                    Class<?> c;
                    if (i.getType() == MemberType.FAKE && AccessFlag.isPublic(i.getAccessFlags())) {
                        c = clazz.getClassLoader().loadClass(i.getClassName());
                        visible.add(i.getMethod(c));
                        continue;
                    }
                    if (i.getType() != MemberType.REMOVED) continue;
                    c = clazz.getClassLoader().loadClass(i.getClassName());
                    visible.remove(i.getMethod(c));
                }
            }
            Method[] ret = new Method[visible.size()];
            for (int i = 0; i < visible.size(); ++i) {
                ret[i] = (Method)visible.get(i);
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Method getMethod(Class<?> clazz, String name, Class<?> ... parameters) throws NoSuchMethodException {
        Class<?> superClass;
        ClassData cd = ClassDataStore.instance().getModifiedClassData(clazz.getClassLoader(), Descriptor.toJvmName(clazz.getName()));
        if (cd == null) {
            Method meth = clazz.getMethod(name, parameters);
            return meth;
        }
        String args = '(' + DescriptorUtils.classArrayToDescriptorString(parameters) + ')';
        MethodData md = cd.getMethodData(name, args);
        for (superClass = clazz; superClass.getSuperclass() != null && md == null && superClass != Object.class; superClass = superClass.getSuperclass()) {
            cd = ClassDataStore.instance().getModifiedClassData(superClass.getClassLoader(), Descriptor.toJvmName(superClass.getName()));
            if (cd == null) continue;
            md = cd.getMethodData(name, args);
        }
        if (md == null) {
            Method meth = clazz.getMethod(name, parameters);
            return meth;
        }
        switch (md.getType()) {
            case NORMAL: {
                Method meth = superClass.getMethod(name, parameters);
                return meth;
            }
            case FAKE: {
                try {
                    if (!AccessFlag.isPublic(md.getAccessFlags())) {
                        throw new NoSuchMethodException(clazz.getName() + "." + name);
                    }
                    Class<?> c = superClass.getClassLoader().loadClass(md.getClassName());
                    Method meth = c.getMethod(name, parameters);
                    return meth;
                }
                catch (NoSuchMethodException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        throw new NoSuchMethodException();
    }

    public static Method getDeclaredMethod(Class<?> clazz, String name, Class<?> ... parameters) throws NoSuchMethodException {
        ClassData cd = ClassDataStore.instance().getModifiedClassData(clazz.getClassLoader(), Descriptor.toJvmName(clazz.getName()));
        if (cd == null || !cd.isReplaceable()) {
            Method meth = clazz.getDeclaredMethod(name, parameters);
            return meth;
        }
        String args = parameters != null ? '(' + DescriptorUtils.classArrayToDescriptorString(parameters) + ')' : "()";
        MethodData md = cd.getMethodData(name, args);
        if (md == null) {
            Method meth = clazz.getDeclaredMethod(name, parameters);
            return meth;
        }
        switch (md.getType()) {
            case NORMAL: {
                Method meth = clazz.getDeclaredMethod(name, parameters);
                return meth;
            }
            case FAKE: {
                try {
                    Class<?> c = clazz.getClassLoader().loadClass(md.getClassName());
                    Method meth = c.getDeclaredMethod(name, parameters);
                    return meth;
                }
                catch (NoSuchMethodException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        throw new NoSuchMethodException();
    }

    public static Class<?> getDeclaringClass(Method m) {
        Class<?> c = m.getDeclaringClass();
        if (c.getName().startsWith("org.fakereplace.proxies")) {
            return ClassDataStore.instance().getRealClassFromProxyName(c.getName());
        }
        return c;
    }

    public static boolean fakeCallRequired(Method method) {
        return method.getDeclaringClass().getName().startsWith("org.fakereplace.proxies");
    }

    public static Object[] prependInstanceToParams(Object object, Object[] array) {
        int length = 0;
        if (array != null) {
            length = array.length;
        }
        Object[] ret = new Object[length + 1];
        ret[0] = object;
        for (int i = 0; i < length; ++i) {
            ret[i + 1] = array[i];
        }
        return ret;
    }
}

