/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.replacement;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.fakereplace.data.AnnotationBuilder;
import org.fakereplace.data.AnnotationDataStore;
import org.fakereplace.javassist.bytecode.AnnotationsAttribute;
import org.fakereplace.javassist.bytecode.ClassFile;
import org.fakereplace.javassist.bytecode.ConstPool;
import org.fakereplace.javassist.bytecode.ParameterAnnotationsAttribute;
import org.fakereplace.javassist.bytecode.annotation.Annotation;

public class AnnotationReplacer {
    public static void processAnnotations(ClassFile file, Class old) {
        AnnotationsAttribute newAns = (AnnotationsAttribute)file.getAttribute("RuntimeVisibleAnnotations");
        AnnotationDataStore.recordClassAnnotations(old, newAns);
        file.addAttribute(AnnotationReplacer.duplicateAnnotationsAttribute(file.getConstPool(), old));
    }

    public static AnnotationsAttribute duplicateAnnotationsAttribute(ConstPool cp, AnnotatedElement element) {
        AnnotationsAttribute oldAns = new AnnotationsAttribute(cp, "RuntimeVisibleAnnotations");
        for (java.lang.annotation.Annotation a : element.getAnnotations()) {
            oldAns.addAnnotation(AnnotationBuilder.createJavassistAnnotation(a, cp));
        }
        return oldAns;
    }

    public static ParameterAnnotationsAttribute duplicateParameterAnnotationsAttribute(ConstPool cp, Method method) {
        ParameterAnnotationsAttribute oldAns = new ParameterAnnotationsAttribute(cp, "RuntimeVisibleParameterAnnotations");
        Annotation[][] anAr = new Annotation[method.getParameterAnnotations().length][];
        for (int i = 0; i < anAr.length; ++i) {
            anAr[i] = new Annotation[method.getParameterAnnotations()[i].length];
            for (int j = 0; j < anAr[i].length; ++j) {
                anAr[i][j] = AnnotationBuilder.createJavassistAnnotation(method.getParameterAnnotations()[i][j], cp);
            }
        }
        oldAns.setAnnotations(anAr);
        return oldAns;
    }

    public static ParameterAnnotationsAttribute duplicateParameterAnnotationsAttribute(ConstPool cp, Constructor<?> method) {
        ParameterAnnotationsAttribute oldAns = new ParameterAnnotationsAttribute(cp, "RuntimeVisibleParameterAnnotations");
        Annotation[][] anAr = new Annotation[method.getParameterAnnotations().length][];
        for (int i = 0; i < anAr.length; ++i) {
            anAr[i] = new Annotation[method.getParameterAnnotations()[i].length];
            for (int j = 0; j < anAr[i].length; ++j) {
                anAr[i][j] = AnnotationBuilder.createJavassistAnnotation(method.getParameterAnnotations()[i][j], cp);
            }
        }
        oldAns.setAnnotations(anAr);
        return oldAns;
    }
}

