/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.runtime;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.fakereplace.com.google.common.base.Function;
import org.fakereplace.com.google.common.collect.MapMaker;

public class FieldReferenceDataStore {
    private static final FieldReferenceDataStore INSTANCE = new FieldReferenceDataStore();
    private final AtomicInteger counter = new AtomicInteger();
    private final Map<FieldReference, Integer> addedFieldNumbers = new MapMaker().makeComputingMap(new Function<FieldReference, Integer>(){

        @Override
        public Integer apply(FieldReference from) {
            return FieldReferenceDataStore.this.counter.incrementAndGet();
        }
    });

    private FieldReferenceDataStore() {
    }

    public Integer getFieldNo(String fieldName, String desc, String sig) {
        return this.addedFieldNumbers.get(new FieldReference(fieldName, desc, sig));
    }

    public static FieldReferenceDataStore instance() {
        return INSTANCE;
    }

    private static class FieldReference {
        private final String name;
        private final String descriptor;
        private final String signiture;

        public FieldReference(String name, String descriptor, String signiture) {
            this.name = name;
            this.descriptor = descriptor;
            this.signiture = signiture;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.descriptor == null ? 0 : this.descriptor.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.signiture == null ? 0 : this.signiture.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FieldReference other = (FieldReference)obj;
            if (this.descriptor == null ? other.descriptor != null : !this.descriptor.equals(other.descriptor)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.signiture == null ? other.signiture != null : !this.signiture.equals(other.signiture));
        }
    }
}

