/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.transformation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.fakereplace.AgentOption;
import org.fakereplace.AgentOptions;
import org.fakereplace.api.ClassChangeAware;
import org.fakereplace.api.ClassChangeNotifier;
import org.fakereplace.api.Extension;
import org.fakereplace.com.google.common.collect.MapMaker;
import org.fakereplace.javassist.bytecode.ClassFile;
import org.fakereplace.transformation.FakereplaceTransformer;
import org.fakereplace.transformation.UnmodifiedFileIndex;
import org.fakereplace.util.FileReader;

public class MainTransformer
implements ClassFileTransformer {
    private volatile FakereplaceTransformer[] transformers = new FakereplaceTransformer[0];
    private final Map<String, Extension> integrationClassTriggers;
    private static final Set<ClassLoader> integrationClassloader = Collections.newSetFromMap(new MapMaker().weakKeys().makeMap());

    public MainTransformer(Set<Extension> extension) {
        HashMap<String, Extension> integrationClassTriggers = new HashMap<String, Extension>();
        for (Extension i : extension) {
            for (String j : i.getIntegrationTriggerClassNames()) {
                integrationClassTriggers.put(j.replace(".", "/"), i);
            }
        }
        this.integrationClassTriggers = integrationClassTriggers;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (this.integrationClassTriggers.containsKey(className)) {
            integrationClassloader.add(loader);
            try {
                Class<?> clazz = Class.forName(this.integrationClassTriggers.get(className).getClassChangeAwareName(), true, loader);
                Object intance = clazz.newInstance();
                if (intance instanceof ClassChangeAware) {
                    ClassChangeNotifier.instance().add((ClassChangeAware)intance);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        boolean changed = false;
        if (UnmodifiedFileIndex.isClassUnmodified(className)) {
            return null;
        }
        try {
            ClassFile file = new ClassFile(new DataInputStream(new ByteArrayInputStream(classfileBuffer)));
            for (FakereplaceTransformer transformer : this.transformers) {
                if (!transformer.transform(loader, className, classBeingRedefined, protectionDomain, file)) continue;
                changed = true;
            }
            if (!changed) {
                UnmodifiedFileIndex.markClassUnmodified(className);
                return null;
            }
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            file.write(new DataOutputStream(bs));
            String dumpDir = AgentOptions.getOption(AgentOption.DUMP_DIR);
            if (dumpDir != null && classBeingRedefined != null) {
                FileOutputStream s = new FileOutputStream(dumpDir + '/' + file.getName() + ".class");
                DataOutputStream dos = new DataOutputStream(s);
                file.write(dos);
                s.close();
            }
            return bs.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalClassFormatException(e.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public synchronized void addTransformer(FakereplaceTransformer transformer) {
        FakereplaceTransformer[] transformers = new FakereplaceTransformer[this.transformers.length + 1];
        for (int i = 0; i < this.transformers.length; ++i) {
            transformers[i] = this.transformers[i];
        }
        transformers[this.transformers.length] = transformer;
        this.transformers = transformers;
    }

    public synchronized void removeTransformer(FakereplaceTransformer transformer) {
        FakereplaceTransformer[] transformers = new FakereplaceTransformer[this.transformers.length - 1];
        int j = 0;
        for (int i = 0; i < this.transformers.length; ++i) {
            FakereplaceTransformer value = this.transformers[i];
            if (value == transformer) continue;
            transformers[++j] = this.transformers[i];
        }
        this.transformers = transformers;
    }

    public static byte[] getIntegrationClass(ClassLoader c, String name) {
        if (!integrationClassloader.contains(c)) {
            return null;
        }
        URL resource = ClassLoader.getSystemClassLoader().getResource(name.replace('.', '/') + ".class");
        InputStream in = null;
        try {
            in = resource.openStream();
            byte[] byArray = FileReader.readFileBytes(resource.openStream());
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {}
        }
    }
}

