/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.transformation;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.fakereplace.AgentOption;
import org.fakereplace.AgentOptions;

public class UnmodifiedFileIndex {
    public static String VERSION = "1.0";
    private static final String FILENAME = "fakereplace.index";
    private static final Set<String> index = Collections.newSetFromMap(new ConcurrentHashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadIndex() {
        File file = UnmodifiedFileIndex.getFile();
        if (file.exists() && !file.isDirectory()) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(file));
                String version = reader.readLine();
                if (VERSION.equals(version)) {
                    String line = reader.readLine();
                    while (line != null) {
                        index.add(line);
                        line = reader.readLine();
                    }
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        Thread writerThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                File file = UnmodifiedFileIndex.getFile();
                if (!file.isDirectory()) {
                    Writer writer = null;
                    try {
                        writer = new BufferedWriter(new FileWriter(file));
                        writer.write(VERSION);
                        writer.write(10);
                        ArrayList sortedIndex = new ArrayList(index);
                        Collections.sort(sortedIndex);
                        for (String clazz : sortedIndex) {
                            writer.write(clazz);
                            writer.write(10);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    finally {
                        if (writer != null) {
                            try {
                                writer.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
        });
        Runtime.getRuntime().addShutdownHook(writerThread);
    }

    private static File getFile() {
        String fileProp = AgentOptions.getOption(AgentOption.INDEX_FILE);
        if (fileProp != null) {
            return new File(fileProp);
        }
        return new File(FILENAME);
    }

    public static void markClassUnmodified(String clazz) {
        index.add(clazz);
    }

    public static boolean isClassUnmodified(String clazz) {
        return index.contains(clazz);
    }
}

