/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class DescriptorUtils {
    public static Method getMethod(String name, String methodDesc, Class actual) {
        try {
            return actual.getMethod(name, DescriptorUtils.argumentStringToClassArray(methodDesc, actual));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getDescriptor(Method method) {
        return "(" + DescriptorUtils.classArrayToDescriptorString(method.getParameterTypes()) + ")" + DescriptorUtils.classToStringRepresentation(method.getReturnType());
    }

    public static String getDescriptor(Constructor<?> method) {
        return "(" + DescriptorUtils.classArrayToDescriptorString(method.getParameterTypes()) + ")V";
    }

    public static Class<?>[] argumentStringToClassArray(String methodDescriptor, Class<?> methodClass) throws ClassNotFoundException {
        int i = 1;
        ArrayList classes = new ArrayList();
        int arraystart = -1;
        while (methodDescriptor.charAt(i) != ')') {
            Class<?> type = null;
            if (methodDescriptor.charAt(i) == '[') {
                if (arraystart == -1) {
                    arraystart = i;
                }
            } else {
                if (methodDescriptor.charAt(i) == 'L') {
                    String className;
                    int start = ++i;
                    while (methodDescriptor.charAt(i) != ';') {
                        ++i;
                    }
                    if (arraystart == -1) {
                        className = methodDescriptor.substring(start, i).replace('/', '.');
                        try {
                            type = methodClass.getClassLoader().loadClass(className);
                        }
                        catch (ClassNotFoundException e) {
                            type = Class.forName(className);
                        }
                    } else {
                        className = methodDescriptor.substring(arraystart, i + 1).replace("/", ".");
                        try {
                            type = methodClass.getClassLoader().loadClass(className);
                        }
                        catch (ClassNotFoundException e) {
                            type = Class.forName(className);
                        }
                    }
                } else if (arraystart == -1) {
                    type = DescriptorUtils.primitiveType(methodDescriptor.charAt(i));
                } else {
                    String className = methodDescriptor.substring(arraystart, i + 1);
                    try {
                        type = methodClass.getClassLoader().loadClass(className);
                    }
                    catch (ClassNotFoundException e) {
                        type = Class.forName(className);
                    }
                }
                arraystart = -1;
                classes.add(type);
            }
            ++i;
        }
        Class[] ret = new Class[classes.size()];
        for (i = 0; i < ret.length; ++i) {
            ret[i] = (Class)classes.get(i);
        }
        return ret;
    }

    public static String[] descriptorStringToParameterArray(String methodDescriptor) {
        int i = 1;
        ArrayList<String> ret = new ArrayList<String>();
        int arraystart = -1;
        while (methodDescriptor.charAt(i) != ')') {
            String type = null;
            if (methodDescriptor.charAt(i) == '[') {
                if (arraystart == -1) {
                    arraystart = i;
                }
            } else {
                if (methodDescriptor.charAt(i) == 'L') {
                    int start = i++;
                    while (methodDescriptor.charAt(i) != ';') {
                        ++i;
                    }
                    type = arraystart == -1 ? methodDescriptor.substring(start, i) : methodDescriptor.substring(arraystart, i);
                } else {
                    type = arraystart == -1 ? methodDescriptor.charAt(i) + "" : methodDescriptor.substring(arraystart, i + 1);
                }
                arraystart = -1;
                ret.add(type);
            }
            ++i;
        }
        String[] r = new String[ret.size()];
        for (int j = 0; j < ret.size(); ++j) {
            r[j] = (String)ret.get(j);
        }
        return r;
    }

    public static String methodSignitureToDescriptor(Class<?> returnType, Class<?> ... params) {
        StringBuilder sb = new StringBuilder("(");
        sb.append(DescriptorUtils.classArrayToDescriptorString(params));
        sb.append(")");
        sb.append(DescriptorUtils.classToStringRepresentation(returnType));
        return sb.toString();
    }

    public static String getReturnType(String descriptor) {
        return descriptor.substring(descriptor.lastIndexOf(41) + 1);
    }

    public static String getReturnTypeInJvmFormat(String descriptor) {
        String rt = descriptor.substring(descriptor.lastIndexOf(41) + 1);
        if (rt.charAt(0) == 'L') {
            rt = rt.substring(1);
            rt = rt.substring(0, rt.length() - 1);
        }
        return rt;
    }

    public static String getTypeStringFromDescriptorFormat(String descriptor) {
        descriptor = descriptor.substring(1);
        descriptor = descriptor.substring(0, descriptor.length() - 1);
        return descriptor;
    }

    public static String getArgumentString(String descriptor) {
        return descriptor.substring(0, descriptor.lastIndexOf(41) + 1);
    }

    public static String classArrayToDescriptorString(Class<?> ... params) {
        if (params == null) {
            return "";
        }
        StringBuilder ret = new StringBuilder();
        for (Class<?> c : params) {
            ret.append(DescriptorUtils.classToStringRepresentation(c));
        }
        return ret.toString();
    }

    public static String classToStringRepresentation(Class<?> c) {
        if (Void.TYPE.equals(c)) {
            return "V";
        }
        if (Byte.TYPE.equals(c)) {
            return "B";
        }
        if (Character.TYPE.equals(c)) {
            return "C";
        }
        if (Double.TYPE.equals(c)) {
            return "D";
        }
        if (Float.TYPE.equals(c)) {
            return "F";
        }
        if (Integer.TYPE.equals(c)) {
            return "I";
        }
        if (Long.TYPE.equals(c)) {
            return "J";
        }
        if (Short.TYPE.equals(c)) {
            return "S";
        }
        if (Boolean.TYPE.equals(c)) {
            return "Z";
        }
        if (c.isArray()) {
            return c.getName().replace(".", "/");
        }
        return DescriptorUtils.extToInt(c.getName());
    }

    static Class<?> primitiveType(char c) {
        switch (c) {
            case 'V': {
                return Void.TYPE;
            }
            case 'B': {
                return Byte.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'Z': {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    public static String extToInt(String className) {
        String repl = className.replace(".", "/");
        return 'L' + repl + ';';
    }

    public static boolean isPrimitive(String descriptor) {
        return descriptor.length() == 1;
    }

    public static boolean isWide(String descriptor) {
        if (!DescriptorUtils.isPrimitive(descriptor)) {
            return false;
        }
        char c = descriptor.charAt(0);
        return c == 'D' || c == 'J';
    }
}

