/*
 * Decompiled with CFR 0.152.
 */
package org.fhir.ucum;

import java.util.Date;
import java.util.List;
import java.util.Set;
import org.fhir.ucum.Concept;
import org.fhir.ucum.ConceptKind;
import org.fhir.ucum.Decimal;
import org.fhir.ucum.DefinedUnit;
import org.fhir.ucum.Pair;
import org.fhir.ucum.UcumException;
import org.fhir.ucum.UcumModel;

public interface UcumService {
    public UcumModel getModel();

    public UcumVersionDetails ucumIdentification();

    public List<String> validateUCUM();

    public List<Concept> search(ConceptKind var1, String var2, boolean var3);

    public Set<String> getProperties();

    public String validate(String var1);

    public String analyse(String var1) throws UcumException;

    public String validateInProperty(String var1, String var2);

    public String validateCanonicalUnits(String var1, String var2);

    public String getCanonicalUnits(String var1) throws UcumException;

    public boolean isComparable(String var1, String var2) throws UcumException;

    public List<DefinedUnit> getDefinedForms(String var1) throws UcumException;

    public Pair getCanonicalForm(Pair var1) throws UcumException;

    public Decimal convert(Decimal var1, String var2, String var3) throws UcumException;

    public Pair multiply(Pair var1, Pair var2) throws UcumException;

    public String getCommonDisplay(String var1);

    public static class UcumVersionDetails {
        private Date releaseDate;
        private String version;

        public UcumVersionDetails(Date releaseDate, String version) {
            this.releaseDate = releaseDate;
            this.version = version;
        }

        public Date getReleaseDate() {
            return this.releaseDate;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

