/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.gds.ng.tz.TimeZoneDatatypeCoder;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FieldDataProvider;

abstract class AbstractWithTimeZoneField
extends FBField {
    private ZoneId defaultZoneId;
    private final TimeZoneDatatypeCoder.TimeZoneCodec timeZoneCodec;

    AbstractWithTimeZoneField(FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(fieldDescriptor, dataProvider, requiredType);
        this.timeZoneCodec = TimeZoneDatatypeCoder.getInstanceFor(this.getDatatypeCoder()).getTimeZoneCodecFor(fieldDescriptor);
    }

    final OffsetDateTime getOffsetDateTime() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.timeZoneCodec.decodeOffsetDateTime(this.getFieldData());
    }

    final void setOffsetDateTime(OffsetDateTime offsetDateTime) throws SQLException {
        this.setFieldData(this.getTimeZoneCodec().encodeOffsetDateTime(offsetDateTime));
    }

    final OffsetTime getOffsetTime() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.timeZoneCodec.decodeOffsetTime(this.getFieldData());
    }

    final void setOffsetTime(OffsetTime offsetTime) throws SQLException {
        this.setFieldData(this.timeZoneCodec.encodeOffsetTime(offsetTime));
    }

    final ZonedDateTime getZonedDateTime() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.timeZoneCodec.decodeZonedDateTime(this.getFieldData());
    }

    final void setZonedDateTime(ZonedDateTime zonedDateTime) throws SQLException {
        this.setFieldData(this.timeZoneCodec.encodeZonedDateTime(zonedDateTime));
    }

    @Override
    public <T> T getObject(Class<T> type) throws SQLException {
        if (type == null) {
            throw new SQLNonTransientException("getObject called with type null");
        }
        switch (type.getName()) {
            case "java.time.OffsetTime": {
                return (T)this.getOffsetTime();
            }
            case "java.time.OffsetDateTime": {
                return (T)this.getOffsetDateTime();
            }
            case "java.time.ZonedDateTime": {
                return (T)this.getZonedDateTime();
            }
        }
        return super.getObject(type);
    }

    @Override
    public void setObject(Object value) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        if (value instanceof OffsetTime) {
            this.setOffsetTime((OffsetTime)value);
        } else if (value instanceof OffsetDateTime) {
            this.setOffsetDateTime((OffsetDateTime)value);
        } else if (value instanceof ZonedDateTime) {
            this.setZonedDateTime((ZonedDateTime)value);
        } else {
            super.setObject(value);
        }
    }

    @Override
    public Time getTime() throws SQLException {
        OffsetDateTime offsetDateTime = this.getOffsetDateTime();
        if (offsetDateTime == null) {
            return null;
        }
        return new Time(offsetDateTime.toInstant().toEpochMilli());
    }

    @Override
    public Time getTime(Calendar cal) throws SQLException {
        return this.getTime();
    }

    @Override
    public void setTime(Time value) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        OffsetDateTime offsetDateTime = ZonedDateTime.of(LocalDate.now(), value.toLocalTime(), this.getDefaultZoneId()).toOffsetDateTime();
        this.setOffsetDateTime(offsetDateTime);
    }

    @Override
    public void setTime(Time value, Calendar cal) throws SQLException {
        this.setTime(value);
    }

    @Override
    public Timestamp getTimestamp() throws SQLException {
        OffsetDateTime offsetDateTime = this.getOffsetDateTime();
        if (offsetDateTime == null) {
            return null;
        }
        return new Timestamp(offsetDateTime.toInstant().toEpochMilli());
    }

    @Override
    public Timestamp getTimestamp(Calendar cal) throws SQLException {
        return this.getTimestamp();
    }

    @Override
    public void setTimestamp(Timestamp value) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        OffsetDateTime offsetDateTime = value.toLocalDateTime().atZone(this.getDefaultZoneId()).toOffsetDateTime();
        this.setOffsetDateTime(offsetDateTime);
    }

    @Override
    public void setTimestamp(Timestamp value, Calendar cal) throws SQLException {
        this.setTimestamp(value);
    }

    final TimeZoneDatatypeCoder.TimeZoneCodec getTimeZoneCodec() {
        return this.timeZoneCodec;
    }

    final ZoneId getDefaultZoneId() {
        if (this.defaultZoneId != null) {
            return this.defaultZoneId;
        }
        this.defaultZoneId = ZoneId.systemDefault();
        return this.defaultZoneId;
    }

    void setStringParse(String value) throws SQLException {
        if (value.indexOf(84) != -1) {
            OffsetDateTime offsetDateTime = OffsetDateTime.parse(value.trim());
            this.setOffsetDateTime(offsetDateTime);
        } else {
            OffsetTime offsetTime = OffsetTime.parse(value.trim());
            this.setOffsetTime(offsetTime);
        }
    }
}

