/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.metadata;

import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import org.firebirdsql.encodings.EncodingFactory;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.gds.ng.DatatypeCoder;
import org.firebirdsql.gds.ng.DefaultDatatypeCoder;
import org.firebirdsql.jdbc.FBDatabaseMetaData;
import org.firebirdsql.util.FirebirdSupportInfo;

public abstract class DbMetadataMediator {
    static final DatatypeCoder datatypeCoder = DefaultDatatypeCoder.forEncodingFactory(EncodingFactory.createInstance(StandardCharsets.UTF_8));

    protected abstract FirebirdSupportInfo getFirebirdSupportInfo();

    protected abstract ResultSet performMetaDataQuery(MetadataQuery var1) throws SQLException;

    protected abstract FBDatabaseMetaData getMetaData();

    protected abstract GDSType getGDSType();

    public static class MetadataQuery {
        private final String queryText;
        private final List<String> parameters;
        private final boolean standalone;

        public MetadataQuery(String queryText, List<String> parameters) {
            this(queryText, parameters, false);
        }

        public MetadataQuery(String queryText, List<String> parameters, boolean standalone) {
            this.queryText = Objects.requireNonNull(queryText, "queryText");
            this.parameters = Objects.requireNonNull(parameters, "parameters");
            this.standalone = standalone;
        }

        public String getQueryText() {
            return this.queryText;
        }

        public List<String> getParameters() {
            return this.parameters;
        }

        public boolean isStandalone() {
            return this.standalone;
        }
    }
}

