/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.crypt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionIdentifier;

public final class KnownServerKey {
    private static final Pattern CRYPT_PLUGIN_LIST_SPLIT = Pattern.compile("[ \t,;]+");
    private final String keyType;
    private final List<String> plugins;
    private final Map<String, byte[]> specificData;

    private KnownServerKey(String keyType, List<String> plugins, Map<String, byte[]> specificData) {
        this.keyType = Objects.requireNonNull(keyType, "keyType");
        this.plugins = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(plugins, "plugins")));
        this.specificData = specificData == null || specificData.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(specificData);
    }

    public KnownServerKey(String keyType, String plugins, Map<String, byte[]> specificData) {
        this(keyType, Arrays.asList(CRYPT_PLUGIN_LIST_SPLIT.split(plugins)), specificData);
    }

    public List<PluginSpecificData> getPluginSpecificData() {
        ArrayList<PluginSpecificData> pluginSpecificData = new ArrayList<PluginSpecificData>(this.plugins.size());
        for (String plugin : this.plugins) {
            EncryptionIdentifier identifier = new EncryptionIdentifier(this.keyType, plugin);
            pluginSpecificData.add(new PluginSpecificData(identifier, this.specificData.get(plugin)));
        }
        return pluginSpecificData;
    }

    public void clear() {
        this.specificData.values().stream().filter(Objects::nonNull).forEach(b -> Arrays.fill(b, (byte)0));
    }

    public static final class PluginSpecificData {
        private final EncryptionIdentifier encryptionIdentifier;
        private final byte[] specificData;

        private PluginSpecificData(EncryptionIdentifier encryptionIdentifier, byte[] specificData) {
            this.encryptionIdentifier = Objects.requireNonNull(encryptionIdentifier, "encryptionIdentifier");
            this.specificData = specificData;
        }

        public EncryptionIdentifier getEncryptionIdentifier() {
            return this.encryptionIdentifier;
        }

        public byte[] getSpecificData() {
            return this.specificData;
        }
    }
}

