/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.crypt.chacha;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.ChaCha20ParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.wire.crypt.CryptSessionConfig;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionIdentifier;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionInitInfo;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionPlugin;
import org.firebirdsql.gds.ng.wire.crypt.chacha.ChaChaEncryptionPluginSpi;
import org.firebirdsql.util.SQLExceptionChainBuilder;

public class ChaChaEncryptionPlugin
implements EncryptionPlugin {
    private static final String CHA_CHA_20_CIPHER_NAME = "ChaCha20";
    private final CryptSessionConfig cryptSessionConfig;

    ChaChaEncryptionPlugin(CryptSessionConfig cryptSessionConfig) {
        this.cryptSessionConfig = cryptSessionConfig;
    }

    @Override
    public EncryptionIdentifier getEncryptionIdentifier() {
        return ChaChaEncryptionPluginSpi.CHA_CHA_ID;
    }

    @Override
    public EncryptionInitInfo initializeEncryption() {
        SQLExceptionChainBuilder<SQLException> chainBuilder = new SQLExceptionChainBuilder<SQLException>();
        Cipher encryptionCipher = null;
        Cipher decryptionCipher = null;
        try (ChaChaIV iv = new ChaChaIV();){
            encryptionCipher = this.createEncryptionCipher(iv, chainBuilder);
            decryptionCipher = this.createDecryptionCipher(iv, chainBuilder);
        }
        catch (SQLException e) {
            chainBuilder.append(e);
        }
        if (chainBuilder.hasException()) {
            return EncryptionInitInfo.failure(this.getEncryptionIdentifier(), chainBuilder.getException());
        }
        return EncryptionInitInfo.success(this.getEncryptionIdentifier(), encryptionCipher, decryptionCipher);
    }

    private Cipher createEncryptionCipher(ChaChaIV iv, SQLExceptionChainBuilder<SQLException> chainBuilder) {
        try {
            return this.createCipher(1, iv, this.toChaChaKey(this.cryptSessionConfig.getEncryptKey()));
        }
        catch (SQLException e) {
            chainBuilder.append(e);
            return null;
        }
    }

    private Cipher createDecryptionCipher(ChaChaIV iv, SQLExceptionChainBuilder<SQLException> chainBuilder) {
        try {
            return this.createCipher(2, iv, this.toChaChaKey(this.cryptSessionConfig.getEncryptKey()));
        }
        catch (SQLException e) {
            chainBuilder.append(e);
            return null;
        }
    }

    private byte[] toChaChaKey(byte[] key) throws SQLException {
        if (key.length < 16) {
            throw new FbExceptionBuilder().nonTransientException(337248282).messageParameter(this.getEncryptionIdentifier().toString()).messageParameter("Key too short").toSQLException();
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            return md.digest(key);
        }
        catch (NoSuchAlgorithmException e) {
            throw new FbExceptionBuilder().nonTransientException(337248281).messageParameter(this.getEncryptionIdentifier().toString()).cause(e).toSQLException();
        }
    }

    private Cipher createCipher(int mode, ChaChaIV iv, byte[] key) throws SQLException {
        try {
            Cipher chaChaCipher = Cipher.getInstance(CHA_CHA_20_CIPHER_NAME);
            SecretKeySpec chaChaKey = new SecretKeySpec(key, CHA_CHA_20_CIPHER_NAME);
            chaChaCipher.init(mode, (Key)chaChaKey, iv.toParameterSpec());
            return chaChaCipher;
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new FbExceptionBuilder().nonTransientException(337248281).messageParameter(this.getEncryptionIdentifier().toString()).cause(e).toSQLException();
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            throw new FbExceptionBuilder().nonTransientException(337248282).messageParameter(this.getEncryptionIdentifier().toString()).cause(e).toSQLException();
        }
    }

    private class ChaChaIV
    implements AutoCloseable {
        private byte[] nonce;
        private int counter;

        ChaChaIV() throws SQLException {
            byte[] iv = ChaChaEncryptionPlugin.this.cryptSessionConfig.getSpecificData();
            if (iv == null || iv.length != 12 && iv.length != 16) {
                throw new FbExceptionBuilder().nonTransientException(337248282).messageParameter(ChaChaEncryptionPlugin.this.getEncryptionIdentifier().toString()).messageParameter("Wrong IV length, needs 12 or 16 bytes").toSQLException();
            }
            this.nonce = Arrays.copyOf(iv, 12);
            if (iv.length == 16) {
                this.counter = (iv[12] << 24) + (iv[13] << 16) + (iv[14] << 8) + iv[15];
            }
        }

        ChaCha20ParameterSpec toParameterSpec() {
            return new ChaCha20ParameterSpec(this.nonce, this.counter);
        }

        @Override
        public void close() {
            Arrays.fill(this.nonce, (byte)0);
            this.nonce = null;
            this.counter = -1;
        }
    }
}

