/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.metadata;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowDescriptorBuilder;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.jdbc.FBDatabaseMetaData;
import org.firebirdsql.jdbc.FBResultSet;
import org.firebirdsql.jdbc.metadata.DbMetadataMediator;
import org.firebirdsql.jdbc.metadata.MetadataPattern;
import org.firebirdsql.jdbc.metadata.RowValueBuilder;

public class GetVersionColumns {
    private static final RowDescriptor ROW_DESCRIPTOR = new RowDescriptorBuilder(8, DbMetadataMediator.datatypeCoder).at(0).simple(500, 0, "SCOPE", "VERSIONCOL").addField().at(1).simple(448, 63, "COLUMN_NAME", "VERSIONCOL").addField().at(2).simple(496, 0, "DATA_TYPE", "VERSIONCOL").addField().at(3).simple(448, 31, "TYPE_NAME", "VERSIONCOL").addField().at(4).simple(496, 0, "COLUMN_SIZE", "VERSIONCOL").addField().at(5).simple(496, 0, "BUFFER_LENGTH", "VERSIONCOL").addField().at(6).simple(500, 0, "DECIMAL_DIGITS", "VERSIONCOL").addField().at(7).simple(500, 0, "PSEUDO_COLUMN", "VERSIONCOL").addField().toRowDescriptor();
    private final DbMetadataMediator mediator;

    private GetVersionColumns(DbMetadataMediator mediator) {
        this.mediator = mediator;
    }

    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        if (table == null || "".equals(table)) {
            return new FBResultSet(ROW_DESCRIPTOR, Collections.emptyList());
        }
        FBDatabaseMetaData dbmd = this.mediator.getMetaData();
        try (ResultSet pseudoColumns = dbmd.getPseudoColumns(catalog, schema, MetadataPattern.escapeWildcards(table), "%");){
            if (!pseudoColumns.next()) {
                FBResultSet fBResultSet = new FBResultSet(ROW_DESCRIPTOR, Collections.emptyList());
                return fBResultSet;
            }
            ArrayList<RowValue> rowValues = new ArrayList<RowValue>(2);
            RowValueBuilder rowValueBuilder = new RowValueBuilder(ROW_DESCRIPTOR);
            do {
                String columnName;
                boolean isDbKey;
                boolean isRecordVersion;
                boolean bl = isRecordVersion = !(isDbKey = "RDB$DB_KEY".equals(columnName = pseudoColumns.getString(4))) && "RDB$RECORD_VERSION".equals(columnName);
                if (!isDbKey && !isRecordVersion) continue;
                rowValueBuilder.at(0).set(null).at(1).setString(columnName).at(2).setInt(pseudoColumns.getInt(5)).at(3).setString(isDbKey ? "CHAR" : "BIGINT").at(4).setInt(pseudoColumns.getInt(6)).at(5).setInt(isDbKey ? pseudoColumns.getInt(11) : 8).at(6).setShort(isRecordVersion ? Integer.valueOf(0) : null).at(7).setShort(2);
                rowValues.add(rowValueBuilder.toRowValue(false));
            } while (pseudoColumns.next());
            FBResultSet fBResultSet = new FBResultSet(ROW_DESCRIPTOR, rowValues);
            return fBResultSet;
        }
    }

    public static GetVersionColumns create(DbMetadataMediator mediator) {
        return new GetVersionColumns(mediator);
    }
}

