/*
 * Decompiled with CFR 0.152.
 */
package org.fossnova.json.stream;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import org.fossnova.finder.FactoryFinder;
import org.fossnova.json.stream.JsonReader;
import org.fossnova.json.stream.JsonWriter;

public abstract class JsonStreamFactory {
    private static final JsonStreamFactory FACTORY = (JsonStreamFactory)FactoryFinder.find(JsonStreamFactory.class);

    protected JsonStreamFactory() {
    }

    public static JsonStreamFactory getInstance() {
        return FACTORY;
    }

    public abstract JsonReader newJsonReader(Reader var1);

    public abstract JsonWriter newJsonWriter(Writer var1);

    public abstract JsonReader newJsonReader(InputStream var1);

    public abstract JsonWriter newJsonWriter(OutputStream var1);

    public abstract JsonReader newJsonReader(InputStream var1, Charset var2);

    public abstract JsonWriter newJsonWriter(OutputStream var1, Charset var2);

    static {
        if (FACTORY == null) {
            throw new IllegalStateException("Factory not configured: " + JsonStreamFactory.class.getName());
        }
    }
}

