/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import org.geolatte.geom.C2D;
import org.geolatte.geom.Positions;

public class Vector {
    public static <P extends C2D> double[] positionToSegment2D(P p0, P p1, P y) {
        P d = Vector.substract(p1, p0);
        P ymp0 = Vector.substract(y, p0);
        double t = Vector.dot(d, ymp0);
        double dd = Vector.dot(d, d);
        if (t <= 0.0) {
            return new double[]{Vector.dot(ymp0, ymp0), t / dd};
        }
        if (t >= dd) {
            P ymp1 = Vector.substract(y, p1);
            return new double[]{Vector.dot(ymp1, ymp1), t / dd};
        }
        double dist = Math.abs(Vector.dot(ymp0, ymp0) - t * t / dd);
        return new double[]{dist, t / dd};
    }

    public static <P extends C2D> double dot(P p0, P p1) {
        if (p0.isEmpty() || p1.isEmpty()) {
            return Double.NaN;
        }
        return p0.getX() * p1.getX() + p0.getY() * p1.getY();
    }

    public static <P extends C2D> P add(P p0, P p1) {
        int dim = p0.getCoordinateDimension();
        double[] result = new double[dim];
        for (int i = 0; i < dim; ++i) {
            result[i] = p0.getCoordinate(i) + p1.getCoordinate(i);
        }
        return (P)((C2D)Positions.mkPosition(p0.getClass(), result));
    }

    public static <P extends C2D> P substract(P p0, P p1) {
        int dim = p0.getCoordinateDimension();
        double[] result = new double[dim];
        for (int i = 0; i < dim; ++i) {
            result[i] = p0.getCoordinate(i) - p1.getCoordinate(i);
        }
        return (P)((C2D)Positions.mkPosition(p0.getClass(), result));
    }

    public static <P extends C2D> P perp(P p) {
        if (p == null || p.isEmpty()) {
            return p;
        }
        double[] crds = p.toArray(null);
        double h = crds[0];
        crds[0] = -crds[1];
        crds[1] = h;
        return (P)((C2D)Positions.mkPosition(p.getClass(), crds));
    }

    public static <P extends C2D> double perpDot(P p0, P p1) {
        if (p0 == null || p1 == null || p0.isEmpty() | p1.isEmpty()) {
            throw new IllegalArgumentException("Null or empty Position passed.");
        }
        return -p0.getY() * p1.getX() + p0.getX() * p1.getY();
    }
}

