/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.ByteOrder;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.Point;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.WkbEncoder;
import org.geolatte.geom.codec.WkbVisitor;

abstract class AbstractWkbEncoder
implements WkbEncoder {
    AbstractWkbEncoder() {
    }

    @Override
    public <P extends Position> ByteBuffer encode(Geometry<P> geometry, ByteOrder byteOrder) {
        ByteBuffer output = ByteBuffer.allocate(this.calculateSize(geometry, true));
        if (byteOrder != null) {
            output.setByteOrder(byteOrder);
        }
        this.writeGeometry(geometry, output);
        output.rewind();
        return output;
    }

    protected <P extends Position> void writeGeometry(Geometry<P> geom, ByteBuffer output) {
        geom.accept(this.newWkbVisitor(output, geom));
    }

    protected <P extends Position> WkbVisitor<P> newWkbVisitor(ByteBuffer output, Geometry<P> geometry) {
        return new WkbVisitor(output);
    }

    protected <P extends Position> int calculateSize(Geometry<P> geom, boolean includeSrid) {
        int size = 5;
        if (geom.getSRID() > 0 && includeSrid) {
            size += 4;
        }
        if (geom.isEmpty()) {
            return size + this.sizeEmptyGeometry(geom);
        }
        if (geom instanceof GeometryCollection) {
            size += this.sizeOfGeometryCollection((GeometryCollection)geom);
        } else if (geom instanceof Polygon) {
            size += this.getPolygonSize((Polygon)geom);
        } else if (geom instanceof Point) {
            size += this.getPointByteSize(geom);
        } else {
            size += 4;
            size += this.getPointByteSize(geom) * geom.getNumPositions();
        }
        return size;
    }

    protected abstract <P extends Position> int sizeEmptyGeometry(Geometry<P> var1);

    private <P extends Position> int getPointByteSize(Geometry<P> geom) {
        return geom.getCoordinateDimension() * 8;
    }

    private <P extends Position> int getPolygonSize(Polygon<P> geom) {
        int size = 4;
        size += geom.isEmpty() ? 0 : 4 * (geom.getNumInteriorRing() + 1);
        return size += this.getPointByteSize(geom) * geom.getNumPositions();
    }

    private <P extends Position, G extends Geometry<P>> int sizeOfGeometryCollection(GeometryCollection<P, G> collection) {
        int size = 4;
        for (Geometry g : collection) {
            size += this.calculateSize(g, false);
        }
        return size;
    }
}

