/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.ByteOrder;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.AbstractWkbDecoder;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.crs.CoordinateReferenceSystems;
import org.geolatte.geom.crs.CrsRegistry;

class MySqlWkbDecoder
extends AbstractWkbDecoder {
    private int srid;

    MySqlWkbDecoder() {
    }

    @Override
    protected void prepare(ByteBuffer byteBuffer) {
        byteBuffer.setByteOrder(ByteOrder.NDR);
        this.srid = byteBuffer.getInt();
    }

    @Override
    protected <P extends Position> CoordinateReferenceSystem<P> readCrs(ByteBuffer byteBuffer, int typeCode, CoordinateReferenceSystem<P> crs) {
        if (crs != null) {
            return crs;
        }
        CoordinateReferenceSystem<?> crsDeclared = CrsRegistry.getCoordinateReferenceSystemForEPSG(this.srid, CoordinateReferenceSystems.PROJECTED_2D_METER);
        return crsDeclared;
    }

    @Override
    protected boolean hasSrid(int typeCode) {
        return true;
    }
}

