/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.oracle;

import java.lang.reflect.Array;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.ArrayList;
import org.geolatte.geom.codec.db.oracle.ElemInfo;
import org.geolatte.geom.codec.db.oracle.ElementType;
import org.geolatte.geom.codec.db.oracle.Ordinates;
import org.geolatte.geom.codec.db.oracle.SDOGType;
import org.geolatte.geom.codec.db.oracle.SDOPoint;
import org.geolatte.geom.codec.db.oracle.TypeGeometry;

public class SDOGeometry {
    private static final String SQL_TYPE_NAME = "MDSYS.SDO_GEOMETRY";
    private static final String SQL_POINT_TYPE_NAME = "MDSYS.SDO_POINT_TYPE";
    private final SDOGType gtype;
    private final int srid;
    private final SDOPoint point;
    private final ElemInfo info;
    private final Ordinates ordinates;

    public SDOGeometry(SDOGType gtype, int srid, SDOPoint point, ElemInfo info, Ordinates ordinates) {
        this.gtype = gtype;
        this.srid = srid;
        this.point = point;
        this.info = info;
        this.ordinates = ordinates;
    }

    public static String getTypeName() {
        return SQL_TYPE_NAME;
    }

    public static String getPointTypeName() {
        return SQL_POINT_TYPE_NAME;
    }

    static String arrayToString(Object array) {
        if (array == null || Array.getLength(array) == 0) {
            return "()";
        }
        int length = Array.getLength(array);
        StringBuilder stb = new StringBuilder();
        stb.append("(").append(Array.get(array, 0));
        for (int i = 1; i < length; ++i) {
            stb.append(",").append(Array.get(array, i));
        }
        stb.append(")");
        return stb.toString();
    }

    static void shiftOrdinateOffset(ElemInfo elemInfo, int offset) {
        for (int i = 0; i < elemInfo.getSize(); ++i) {
            int newOffset = elemInfo.getOrdinatesOffset(i) + offset;
            elemInfo.setOrdinatesOffset(i, newOffset);
        }
    }

    private static SDOGType deriveGTYPE(ElementType elementType, SDOGeometry origGeom) {
        switch (elementType) {
            case POINT: 
            case ORIENTATION: {
                return new SDOGType(origGeom.getDimension(), origGeom.getLRSDimension(), TypeGeometry.POINT);
            }
            case POINT_CLUSTER: {
                return new SDOGType(origGeom.getDimension(), origGeom.getLRSDimension(), TypeGeometry.MULTIPOINT);
            }
            case LINE_ARC_SEGMENTS: 
            case LINE_STRAITH_SEGMENTS: 
            case COMPOUND_LINE: {
                return new SDOGType(origGeom.getDimension(), origGeom.getLRSDimension(), TypeGeometry.LINE);
            }
            case COMPOUND_EXTERIOR_RING: 
            case EXTERIOR_RING_ARC_SEGMENTS: 
            case EXTERIOR_RING_CIRCLE: 
            case EXTERIOR_RING_RECT: 
            case EXTERIOR_RING_STRAIGHT_SEGMENTS: {
                return new SDOGType(origGeom.getDimension(), origGeom.getLRSDimension(), TypeGeometry.POLYGON);
            }
        }
        return null;
    }

    public static SDOGeometry load(Struct struct) {
        Object[] data;
        try {
            data = struct.getAttributes();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return new SDOGeometry(SDOGType.parse(data[0]), SDOGeometry.parseSRID(data[1]), data[2] == null ? null : new SDOPoint((Struct)data[2]), new ElemInfo((java.sql.Array)data[3]), new Ordinates((java.sql.Array)data[4]));
    }

    public ElemInfo getInfo() {
        return this.info;
    }

    public SDOGType getGType() {
        return this.gtype;
    }

    public Ordinates getOrdinates() {
        return this.ordinates;
    }

    public SDOPoint getPoint() {
        return this.point;
    }

    public int getSRID() {
        return this.srid;
    }

    private static int parseSRID(Object datum) {
        if (datum == null) {
            return 0;
        }
        try {
            return ((Number)datum).intValue();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isLRSGeometry() {
        return this.gtype.isLRSGeometry();
    }

    public int getDimension() {
        return this.gtype.getDimension();
    }

    public int getLRSDimension() {
        return this.gtype.getLRSDimension();
    }

    public int getZDimension() {
        return this.gtype.getZDimension();
    }

    public int getNumElements() {
        int cnt = 0;
        int i = 0;
        while (i < this.info.getSize()) {
            if (this.info.getElementType(i).isCompound()) {
                int numCompounds = this.info.getNumCompounds(i);
                i += 1 + numCompounds;
            } else {
                ++i;
            }
            ++cnt;
        }
        return cnt;
    }

    public String toString() {
        StringBuilder stb = new StringBuilder();
        stb.append("(").append(this.gtype).append(",").append(this.srid).append(",").append(this.point).append(",").append(this.info).append(",").append(this.ordinates).append(")");
        return stb.toString();
    }

    public SDOGeometry[] getElementGeometries() {
        if (this.getGType().getTypeGeometry() == TypeGeometry.COLLECTION) {
            ArrayList<SDOGeometry> elements = new ArrayList<SDOGeometry>();
            int i = 0;
            while (i < this.getNumElements()) {
                int next;
                ElementType et = this.getInfo().getElementType(i);
                if (et.isExteriorRing()) {
                    for (next = i + 1; next < this.getNumElements() && this.getInfo().getElementType(next).isInteriorRing(); ++next) {
                    }
                } else if (et.isCompound()) {
                    next = i + this.getInfo().getNumCompounds(i) + 1;
                }
                SDOGType elemGtype = SDOGeometry.deriveGTYPE(this.getInfo().getElementType(i), this);
                ElemInfo elemInfo = new ElemInfo(this.getInfo().getElement(i));
                SDOGeometry.shiftOrdinateOffset(elemInfo, -elemInfo.getOrdinatesOffset(0) + 1);
                int startPosition = this.getInfo().getOrdinatesOffset(i);
                Ordinates elemOrdinates = null;
                if (next < this.getNumElements()) {
                    int endPosition = this.getInfo().getOrdinatesOffset(next);
                    elemOrdinates = new Ordinates(this.getOrdinates().getOrdinatesArray(startPosition, endPosition));
                } else {
                    elemOrdinates = new Ordinates(this.getOrdinates().getOrdinatesArray(startPosition));
                }
                SDOGeometry elemGeom = new SDOGeometry(elemGtype, this.getSRID(), null, elemInfo, elemOrdinates);
                elements.add(elemGeom);
                i = next;
            }
            return elements.toArray(new SDOGeometry[elements.size()]);
        }
        return new SDOGeometry[]{this};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SDOGeometry that = (SDOGeometry)o;
        if (this.srid != that.srid) {
            return false;
        }
        if (this.gtype != null ? !this.gtype.equals(that.gtype) : that.gtype != null) {
            return false;
        }
        if (this.info != null ? !this.info.equals(that.info) : that.info != null) {
            return false;
        }
        if (this.ordinates != null ? !this.ordinates.equals(that.ordinates) : that.ordinates != null) {
            return false;
        }
        return !(this.point != null ? !this.point.equals(that.point) : that.point != null);
    }

    public int hashCode() {
        int result = this.gtype != null ? this.gtype.hashCode() : 0;
        result = 31 * result + this.srid;
        result = 31 * result + (this.point != null ? this.point.hashCode() : 0);
        result = 31 * result + (this.info != null ? this.info.hashCode() : 0);
        result = 31 * result + (this.ordinates != null ? this.ordinates.hashCode() : 0);
        return result;
    }
}

