/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.sqlserver;

import org.geolatte.geom.Point;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.codec.db.sqlserver.AbstractSqlServerDecoder;
import org.geolatte.geom.codec.db.sqlserver.IndexRange;
import org.geolatte.geom.codec.db.sqlserver.OpenGisType;
import org.geolatte.geom.codec.db.sqlserver.SqlServerGeometry;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

class PointSqlServerDecoder
extends AbstractSqlServerDecoder {
    PointSqlServerDecoder() {
    }

    @Override
    protected OpenGisType getOpenGisType() {
        return OpenGisType.POINT;
    }

    protected Point<?> createNullGeometry(CoordinateReferenceSystem<?> crs) {
        return new Point(crs);
    }

    protected Point<?> createGeometry(SqlServerGeometry nativeGeom) {
        return this.createPoint(nativeGeom, 0);
    }

    protected Point<?> createGeometry(SqlServerGeometry nativeGeom, int shapeIndex) {
        if (nativeGeom.isEmptyShape(shapeIndex)) {
            return this.createNullGeometry((CoordinateReferenceSystem)nativeGeom.getCoordinateReferenceSystem());
        }
        int figureOffset = nativeGeom.getFiguresForShape((int)shapeIndex).start;
        int pntOffset = nativeGeom.getPointsForFigure((int)figureOffset).start;
        return this.createPoint(nativeGeom, pntOffset);
    }

    private Point<?> createPoint(SqlServerGeometry nativeGeom, int pntOffset) {
        PositionSequence<?> positionSequence = nativeGeom.coordinateRange(new IndexRange(pntOffset, pntOffset + 1));
        return new Point(positionSequence, (CoordinateReferenceSystem<PositionSequence<?>>)nativeGeom.getCoordinateReferenceSystem());
    }
}

