/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import org.geolatte.geom.AbstractGeometryCollection;
import org.geolatte.geom.ExactPositionEquality;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryEquality;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.Position;
import org.geolatte.geom.PositionEquality;
import org.geolatte.geom.PositionSequenceEquality;
import org.geolatte.geom.PositionSequencePositionEquality;

public class GeometryPositionEquality
implements GeometryEquality {
    private final PositionSequenceEquality pointSeqEq;

    public GeometryPositionEquality(PositionEquality pointEq) {
        this.pointSeqEq = new PositionSequencePositionEquality(pointEq);
    }

    public GeometryPositionEquality() {
        ExactPositionEquality pointEquality = new ExactPositionEquality();
        this.pointSeqEq = new PositionSequencePositionEquality(pointEquality);
    }

    @Override
    public <P extends Position> boolean equals(Geometry<P> first, Geometry<P> second) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        if (first.isEmpty() && second.isEmpty()) {
            return true;
        }
        if (first.isEmpty() || second.isEmpty()) {
            return false;
        }
        if (!first.getCoordinateReferenceSystem().equals(second.getCoordinateReferenceSystem())) {
            return false;
        }
        if (first.getGeometryType() != second.getGeometryType()) {
            return false;
        }
        if (first instanceof AbstractGeometryCollection) {
            assert (second instanceof AbstractGeometryCollection);
            return this.equals((AbstractGeometryCollection)first, (AbstractGeometryCollection)second);
        }
        if (first instanceof Polygon) {
            assert (second instanceof Polygon);
            return this.equals((Polygon)first, (Polygon)second);
        }
        return this.pointSeqEq.equals(first.getPositions(), second.getPositions());
    }

    private <P extends Position> boolean equals(Polygon<P> first, Polygon<P> second) {
        if (first.getNumInteriorRing() != second.getNumInteriorRing()) {
            return false;
        }
        if (!this.equals(first.getExteriorRing(), second.getExteriorRing())) {
            return false;
        }
        for (int i = 0; i < first.getNumInteriorRing(); ++i) {
            if (this.equals(first.getInteriorRingN(i), second.getInteriorRingN(i))) continue;
            return false;
        }
        return true;
    }

    private boolean equals(AbstractGeometryCollection first, AbstractGeometryCollection second) {
        if (first.getNumGeometries() != second.getNumGeometries()) {
            return false;
        }
        for (int i = 0; i < first.getNumGeometries(); ++i) {
            if (this.equals((Geometry)first.getGeometryN(i), (Geometry)second.getGeometryN(i))) continue;
            return false;
        }
        return true;
    }
}

