/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import java.util.ArrayList;
import java.util.List;
import org.geolatte.geom.AbstractGeometryCollection;
import org.geolatte.geom.C2D;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.GeometryVisitor;
import org.geolatte.geom.LineSegment;
import org.geolatte.geom.LineSegments;
import org.geolatte.geom.LineString;
import org.geolatte.geom.Measured;
import org.geolatte.geom.MultiLineString;
import org.geolatte.geom.MultiPoint;
import org.geolatte.geom.Point;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.Position;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.PositionSequenceBuilder;
import org.geolatte.geom.PositionSequenceBuilders;
import org.geolatte.geom.Positions;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

public class MeasureInterpolatingVisitor<P extends C2D>
implements GeometryVisitor<P> {
    private static final String INVALID_TYPE_MSG = "Operation only valid on Point, MultiPoint, LineString, and MultiLineString Geometries.";
    private final Geometry<P> geometry;
    private final double startMeasure;
    private final double endMeasure;
    private final List<PositionSequence<P>> positionSequences = new ArrayList<PositionSequence<P>>();
    private PositionSequenceBuilder<P> currentBuilder;
    private boolean sequenceIsEmpty = true;

    public MeasureInterpolatingVisitor(Geometry<P> geometry, double startMeasure, double endMeasure) {
        if (startMeasure <= endMeasure) {
            this.startMeasure = startMeasure;
            this.endMeasure = endMeasure;
        } else {
            this.startMeasure = endMeasure;
            this.endMeasure = startMeasure;
        }
        this.geometry = geometry;
    }

    @Override
    public void visit(Point<P> point) {
        C2D pos = (C2D)point.getPosition();
        if (((Measured)((Object)pos)).getM() >= this.startMeasure && ((Measured)((Object)pos)).getM() <= this.endMeasure) {
            this.positionSequences.add(point.getPositions());
        }
    }

    @Override
    public void visit(LineString<P> lineString) {
        this.currentBuilder = PositionSequenceBuilders.variableSized(this.geometry.getPositionClass());
        C2D lastAddedPoint = null;
        LineSegments segments = new LineSegments(lineString.getPositions());
        for (LineSegment segment : segments) {
            C2D p0 = (C2D)segment.getStartPosition();
            C2D p1 = (C2D)segment.getEndPosition();
            double rs = (this.startMeasure - ((Measured)((Object)p0)).getM()) / (((Measured)((Object)p1)).getM() - ((Measured)((Object)p0)).getM());
            double re = (this.endMeasure - ((Measured)((Object)p0)).getM()) / (((Measured)((Object)p1)).getM() - ((Measured)((Object)p0)).getM());
            double r1 = Math.min(rs, re);
            double r2 = Math.max(rs, re);
            if (this.startMeasure <= ((Measured)((Object)p0)).getM() && ((Measured)((Object)p0)).getM() <= this.endMeasure) {
                lastAddedPoint = this.addIfNotEqualLast(lastAddedPoint, p0);
            } else {
                this.startNewPointSequenceIfNotEmpty();
                if (r1 > 0.0 && r1 < 1.0) {
                    lastAddedPoint = this.addIfNotEqualLast(lastAddedPoint, this.interpolate(p0, p1, r1));
                }
            }
            if (this.startMeasure <= ((Measured)((Object)p1)).getM() && ((Measured)((Object)p1)).getM() <= this.endMeasure) {
                lastAddedPoint = this.addIfNotEqualLast(lastAddedPoint, p1);
                continue;
            }
            if (r2 > 0.0 && r2 < 1.0) {
                lastAddedPoint = this.addIfNotEqualLast(lastAddedPoint, this.interpolate(p0, p1, r2));
            }
            this.startNewPointSequenceIfNotEmpty();
        }
        PositionSequence<P> last = this.currentBuilder.toPositionSequence();
        if (!last.isEmpty()) {
            this.positionSequences.add(last);
        }
    }

    private void startNewPointSequenceIfNotEmpty() {
        if (!this.sequenceIsEmpty) {
            this.positionSequences.add(this.currentBuilder.toPositionSequence());
            this.currentBuilder = PositionSequenceBuilders.variableSized(this.geometry.getPositionClass());
            this.sequenceIsEmpty = true;
        }
    }

    private P addIfNotEqualLast(P lastPoint, P newPnt) {
        assert (newPnt != null);
        if (!((Position)newPnt).equals(lastPoint)) {
            this.currentBuilder.add(newPnt);
            lastPoint = newPnt;
        }
        return lastPoint;
    }

    private P interpolate(P p0, P p1, double r) {
        int dim = this.getCrs().getCoordinateDimension();
        double[] result = new double[dim];
        for (int i = 0; i < dim; ++i) {
            result[i] = ((Position)p0).getCoordinate(i) + r * (((Position)p1).getCoordinate(i) - ((Position)p0).getCoordinate(i));
        }
        return (P)((C2D)Positions.mkPosition(this.getCrs(), result));
    }

    @Override
    public void visit(Polygon<P> polygon) {
        throw new IllegalArgumentException(INVALID_TYPE_MSG);
    }

    @Override
    public void visit(AbstractGeometryCollection collection) {
    }

    public Geometry<P> result() {
        int number0Dimensional = 0;
        int number1Dimensional = 0;
        for (PositionSequence<P> ps : this.positionSequences) {
            assert (!ps.isEmpty());
            if (ps.size() > 1) {
                ++number1Dimensional;
                continue;
            }
            ++number0Dimensional;
        }
        if (number0Dimensional == 0 && number1Dimensional == 0) {
            P p = Positions.mkPosition(this.getCrs(), Double.NaN, Double.NaN);
            return new Point<P>(p, this.getCrs());
        }
        if (number0Dimensional > 1 && number1Dimensional == 0) {
            Point[] pnts = new Point[number0Dimensional];
            int i = 0;
            for (PositionSequence<P> ps : this.positionSequences) {
                pnts[i++] = new Point<PositionSequence<P>>(ps, this.geometry.getCoordinateReferenceSystem());
            }
            return new MultiPoint(pnts);
        }
        if (number0Dimensional == 1 && number1Dimensional == 0) {
            return new MultiPoint(new Point<PositionSequence<P>>(this.positionSequences.get(0), this.geometry.getCoordinateReferenceSystem()));
        }
        if (number0Dimensional == 0 && number1Dimensional >= 1) {
            LineString[] lineStrings = new LineString[number1Dimensional];
            int i = 0;
            for (PositionSequence<P> ps : this.positionSequences) {
                lineStrings[i++] = new LineString<P>(ps, this.geometry.getCoordinateReferenceSystem());
            }
            return new MultiLineString(lineStrings);
        }
        if (number0Dimensional > 0 && number1Dimensional > 0) {
            Geometry[] geometries = new Geometry[number1Dimensional + number0Dimensional];
            int i = 0;
            for (PositionSequence<P> ps : this.positionSequences) {
                if (ps.size() == 1) {
                    geometries[i++] = new Point<PositionSequence<P>>(ps, this.geometry.getCoordinateReferenceSystem());
                    continue;
                }
                geometries[i++] = new LineString<P>(ps, this.geometry.getCoordinateReferenceSystem());
            }
            return new GeometryCollection(geometries);
        }
        throw new IllegalStateException(String.format("Programming error: Case of % d 0-Dim. en %d 1-Dim not properly handled", number0Dimensional, number1Dimensional));
    }

    private CoordinateReferenceSystem<P> getCrs() {
        return this.geometry.getCoordinateReferenceSystem();
    }
}

