/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import java.util.Arrays;
import java.util.Iterator;
import org.geolatte.geom.AbstractPositionSequence;
import org.geolatte.geom.LLAPositionVisitor;
import org.geolatte.geom.Position;
import org.geolatte.geom.PositionFactory;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.PositionVisitor;
import org.locationtech.jts.geom.CoordinateSequence;

class NestedPositionSequence<P extends Position>
extends AbstractPositionSequence<P> {
    protected final PositionSequence<P>[] children;
    private final int size;

    NestedPositionSequence(PositionSequence<P>[] children) {
        super(NestedPositionSequence.extractFactory(children));
        this.children = children;
        this.size = this.calculateSize();
    }

    private static <C extends Position> PositionFactory<C> extractFactory(PositionSequence<C>[] children) {
        if (children == null) {
            throw new IllegalArgumentException("Null or empty children array not allowed.");
        }
        PositionFactory<C> factory = null;
        for (PositionSequence<C> seq : children) {
            if (seq == null) {
                throw new IllegalArgumentException("No null entries allowed in children array.");
            }
            if (seq.isEmpty()) continue;
            if (factory != null && !factory.equals(seq.getPositionFactory())) {
                throw new IllegalArgumentException("All child sequences must have the same Coordinate Reference System");
            }
            factory = seq.getPositionFactory();
        }
        return factory;
    }

    private int calculateSize() {
        int size = 0;
        for (PositionSequence<P> child : this.getChildren()) {
            size += child.size();
        }
        return size;
    }

    public PositionSequence<P>[] getChildren() {
        return Arrays.copyOf(this.children, this.children.length);
    }

    @Override
    public boolean isEmpty() {
        return this.children.length == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    @Deprecated
    public NestedPositionSequence<P> clone() {
        return this;
    }

    public NestedPositionSequence<P> copy() {
        return this;
    }

    @Override
    public void setOrdinate(int position, int ordinateIndex, double value) {
        int childOffset = position;
        for (PositionSequence<P> pChild : this.getChildren()) {
            CoordinateSequence child = (CoordinateSequence)pChild;
            if (childOffset < child.size()) {
                child.setOrdinate(childOffset, ordinateIndex, value);
                return;
            }
            childOffset -= child.size();
        }
        throw new ArrayIndexOutOfBoundsException(String.format("Index %d not found in collection of size %d", position, this.size()));
    }

    @Override
    public void getCoordinates(int position, double[] coordinates) {
        int childOffset = position;
        for (PositionSequence<P> child : this.getChildren()) {
            if (childOffset < child.size()) {
                child.getCoordinates(childOffset, coordinates);
                return;
            }
            childOffset -= child.size();
        }
        throw new ArrayIndexOutOfBoundsException(String.format("Index %d not found in collection of size %d", position, this.size()));
    }

    @Override
    public void accept(PositionVisitor<P> visitor) {
        for (PositionSequence<P> child : this.getChildren()) {
            child.accept(visitor);
        }
    }

    @Override
    public void accept(LLAPositionVisitor visitor) {
        for (PositionSequence<P> child : this.getChildren()) {
            child.accept(visitor);
        }
    }

    @Override
    public PositionSequence<P> reverse() {
        PositionSequence<P>[] childrenCopy = this.getChildren();
        for (int i = 0; i < childrenCopy.length; ++i) {
            childrenCopy[i] = childrenCopy[i].reverse();
        }
        this.reverseInPlace(childrenCopy);
        return new NestedPositionSequence<P>(childrenCopy);
    }

    private void reverseInPlace(PositionSequence<P>[] arr) {
        for (int i = 0; i < arr.length / 2; ++i) {
            PositionSequence<P> h = arr[i];
            arr[i] = arr[arr.length - 1 - i];
            arr[arr.length - 1 - i] = h;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NestedPositionSequence that = (NestedPositionSequence)o;
        if (this.size != that.size) {
            return false;
        }
        return Arrays.equals(this.children, that.children);
    }

    public int hashCode() {
        int result = this.children != null ? Arrays.hashCode(this.children) : 0;
        result = 31 * result + this.size;
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (int i = 0; i < this.children.length; ++i) {
            if (i > 0) {
                builder.append(",");
            }
            builder.append(this.getChildren()[i].toString());
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public Iterator<P> iterator() {
        return new Iterator<P>(){
            private int childIndex = 0;
            private Iterator<P> currentChildIterator;

            @Override
            public boolean hasNext() {
                this.advanceChildIterator();
                return this.currentChildIterator.hasNext();
            }

            private void advanceChildIterator() {
                while (!(this.childIndex >= NestedPositionSequence.this.children.length || this.currentChildIterator != null && this.currentChildIterator.hasNext())) {
                    this.currentChildIterator = NestedPositionSequence.this.children[this.childIndex++].iterator();
                }
            }

            @Override
            public P next() {
                return (Position)this.currentChildIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove not supported on PointSets.");
            }
        };
    }
}

