/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.ByteOrder;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.WkbDecodeException;
import org.geolatte.geom.codec.WkbDialect;
import org.geolatte.geom.codec.support.CollectionGeometryBuilder;
import org.geolatte.geom.codec.support.DecodeException;
import org.geolatte.geom.codec.support.GeometryBuilder;
import org.geolatte.geom.codec.support.LinearPositionsHolder;
import org.geolatte.geom.codec.support.LinearPositionsListHolder;
import org.geolatte.geom.codec.support.PointHolder;
import org.geolatte.geom.codec.support.PolygonListHolder;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.crs.CoordinateReferenceSystems;

class BaseWkbParser<P extends Position> {
    protected final ByteBuffer buffer;
    protected final WkbDialect dialect;
    protected boolean hasZ = false;
    protected boolean hasM = false;
    protected GeometryType gtype;
    protected CoordinateReferenceSystem<P> outputCRS;
    protected CoordinateReferenceSystem<?> embeddedCRS;

    BaseWkbParser(WkbDialect dialect, ByteBuffer buffer, CoordinateReferenceSystem<P> crs) {
        this.buffer = buffer;
        this.buffer.rewind();
        this.dialect = dialect;
        this.outputCRS = crs;
    }

    Geometry<P> parse() throws WkbDecodeException {
        GeometryBuilder builder = this.parseGeometry();
        CoordinateReferenceSystem<P> crs = this.resolveCrs();
        try {
            return builder.createGeometry(crs);
        }
        catch (DecodeException de) {
            throw new WkbDecodeException(de);
        }
    }

    protected CoordinateReferenceSystem<P> resolveCrs() {
        if (this.outputCRS != null) {
            this.isCrsCompatible(this.outputCRS);
            return this.outputCRS;
        }
        CoordinateReferenceSystem crs = this.embeddedCRS != null ? this.embeddedCRS : CoordinateReferenceSystems.PROJECTED_2D_METER;
        return CoordinateReferenceSystems.adjustTo(crs, this.hasZ, this.hasM);
    }

    protected GeometryBuilder parseGeometry() {
        this.parseByteOrder();
        GeometryBuilder builder = this.parseWkbType();
        switch (this.gtype) {
            case POINT: {
                this.matchPoint(builder);
                break;
            }
            case LINESTRING: {
                this.matchLineString(builder);
                break;
            }
            case POLYGON: {
                this.matchPolygon(builder);
                break;
            }
            case MULTIPOINT: {
                this.matchMultiPoint(builder);
                break;
            }
            case MULTILINESTRING: {
                this.matchMultiLineString(builder);
                break;
            }
            case MULTIPOLYGON: {
                this.matchMultiPolygon(builder);
                break;
            }
            case GEOMETRYCOLLECTION: {
                this.matchGeometryCollection((CollectionGeometryBuilder)builder);
                break;
            }
            default: {
                throw new WkbDecodeException("Can't decode a WKB of type " + (Object)((Object)this.gtype));
            }
        }
        return builder;
    }

    protected void parseByteOrder() {
        byte bo = this.buffer.get();
        ByteOrder byteOrder = ByteOrder.valueOf(bo);
        this.buffer.setByteOrder(byteOrder);
    }

    protected GeometryBuilder parseWkbType() {
        long tpe = this.buffer.getUInt();
        this.gtype = this.dialect.parseType(tpe);
        this.hasZ = this.dialect.hasZ(tpe);
        this.hasM = this.dialect.hasM(tpe);
        return GeometryBuilder.create(this.gtype);
    }

    protected void matchPoint(GeometryBuilder builder) {
        PointHolder ph = this.readPosition();
        builder.setPositions(ph);
    }

    protected PointHolder readPosition() {
        PointHolder ph = new PointHolder();
        ph.push(this.buffer.getDouble());
        ph.push(this.buffer.getDouble());
        if (this.hasZ) {
            ph.push(this.buffer.getDouble());
        }
        if (this.hasM) {
            ph.push(this.buffer.getDouble());
        }
        return ph;
    }

    protected void matchLineString(GeometryBuilder builder) {
        LinearPositionsHolder lh = this.readLinestring();
        builder.setPositions(lh);
    }

    protected LinearPositionsHolder readLinestring() {
        LinearPositionsHolder lh = new LinearPositionsHolder();
        long numPositions = this.buffer.getUInt();
        for (long i = 0L; i < numPositions; ++i) {
            lh.push(this.readPosition());
        }
        return lh;
    }

    protected void matchPolygon(GeometryBuilder builder) {
        LinearPositionsListHolder llh = this.readPolygon();
        builder.setPositions(llh);
    }

    private LinearPositionsListHolder readPolygon() {
        LinearPositionsListHolder llh = new LinearPositionsListHolder();
        long numRings = this.buffer.getUInt();
        for (long i = 0L; i < numRings; ++i) {
            llh.push(this.readLinestring());
        }
        return llh;
    }

    protected void matchMultiPoint(GeometryBuilder builder) {
        LinearPositionsHolder lh = new LinearPositionsHolder();
        long numPnts = this.buffer.getUInt();
        for (long i = 0L; i < numPnts; ++i) {
            this.parseByteOrder();
            this.buffer.getUInt();
            lh.push(this.readPosition());
        }
        builder.setPositions(lh);
    }

    protected void matchMultiLineString(GeometryBuilder builder) {
        LinearPositionsListHolder llh = new LinearPositionsListHolder();
        long numl = this.buffer.getUInt();
        for (long i = 0L; i < numl; ++i) {
            this.parseByteOrder();
            this.buffer.getUInt();
            llh.push(this.readLinestring());
        }
        builder.setPositions(llh);
    }

    protected void matchMultiPolygon(GeometryBuilder builder) {
        PolygonListHolder plh = new PolygonListHolder();
        long nump = this.buffer.getUInt();
        for (long i = 0L; i < nump; ++i) {
            this.parseByteOrder();
            this.buffer.getUInt();
            plh.push(this.readPolygon());
        }
        builder.setPositions(plh);
    }

    protected void isCrsCompatible(CoordinateReferenceSystem<?> crs) {
        if (this.hasM && !crs.hasM() || this.hasZ && !crs.hasZ()) {
            throw new WkbDecodeException("WKB inconsistent with specified Coordinate Reference System");
        }
    }

    private void matchGeometryCollection(CollectionGeometryBuilder builder) {
        long numg = this.buffer.getUInt();
        for (long i = 0L; i < numg; ++i) {
            builder.push(this.parseGeometry());
        }
    }
}

