/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import java.util.Optional;
import java.util.regex.Pattern;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.BaseWktParser;
import org.geolatte.geom.codec.PostgisWktDialect;
import org.geolatte.geom.codec.WktDecodeException;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.crs.CoordinateReferenceSystems;
import org.geolatte.geom.crs.CrsRegistry;

class PostgisWktParser<P extends Position>
extends BaseWktParser<P> {
    private static final PostgisWktDialect dialect = new PostgisWktDialect();
    private static final Pattern SRID_RE = Pattern.compile("^SRID=(.*);", 2);

    public PostgisWktParser(String wkt, CoordinateReferenceSystem<P> crs) {
        super(dialect, wkt, crs);
    }

    public PostgisWktParser(PostgisWktDialect dialect, String wkt, CoordinateReferenceSystem<P> crs) {
        super(dialect, wkt, crs);
    }

    @Override
    protected void matchesOptionalZMMarkers() {
        this.tokenizer.skipWhitespace();
        if (this.tokenizer.matchesOneOf('Z', 'z').isPresent()) {
            this.hasZMark = true;
        }
        if (this.tokenizer.matchesOneOf('M', 'm').isPresent()) {
            this.hasMMark = true;
        }
    }

    @Override
    protected void matchesOptionalSrid() {
        Optional<String> sridOpt = this.tokenizer.extractGroupFromPattern(SRID_RE, 1);
        if (sridOpt.isPresent()) {
            try {
                int sridCode = Integer.parseInt(sridOpt.get());
                this.setMatchedSrid(CrsRegistry.getCoordinateReferenceSystemForEPSG(sridCode, CoordinateReferenceSystems.PROJECTED_2D_METER));
            }
            catch (NumberFormatException e) {
                throw new WktDecodeException("Not a valid SRID code in WKT " + sridOpt.get());
            }
        }
    }
}

