/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.oracle;

import java.sql.SQLException;
import java.sql.Struct;

class SDOPoint {
    public Double x;
    public Double y;
    public Double z = null;

    public SDOPoint(Double x, Double y) {
        this(x, y, null);
    }

    public SDOPoint(Double x, Double y, Double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public SDOPoint(Double[] ordinates) {
        this(ordinates[0], ordinates[1], ordinates.length > 2 ? ordinates[2] : null);
    }

    public SDOPoint(Struct struct) {
        try {
            Object[] data = struct.getAttributes();
            this.x = ((Number)data[0]).doubleValue();
            this.y = ((Number)data[1]).doubleValue();
            if (data[2] != null) {
                this.z = ((Number)data[2]).doubleValue();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder stb = new StringBuilder();
        stb.append("(").append(this.x).append(",").append(this.y).append(",").append(this.z).append(")");
        return stb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SDOPoint sdoPoint = (SDOPoint)o;
        if (!this.x.equals(sdoPoint.x)) {
            return false;
        }
        if (!this.y.equals(sdoPoint.y)) {
            return false;
        }
        return this.z != null ? this.z.equals(sdoPoint.z) : sdoPoint.z == null;
    }

    public int hashCode() {
        int result = this.x.hashCode();
        result = 31 * result + this.y.hashCode();
        result = 31 * result + (this.z != null ? this.z.hashCode() : 0);
        return result;
    }
}

