/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.sqlserver;

import java.util.List;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.Point;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.db.sqlserver.AbstractSqlServerEncoder;
import org.geolatte.geom.codec.db.sqlserver.CountingPositionSequenceBuilder;
import org.geolatte.geom.codec.db.sqlserver.Figure;
import org.geolatte.geom.codec.db.sqlserver.FigureAttribute;
import org.geolatte.geom.codec.db.sqlserver.OpenGisType;
import org.geolatte.geom.codec.db.sqlserver.Shape;
import org.geolatte.geom.codec.db.sqlserver.SqlServerGeometry;
import org.geolatte.geom.crs.CoordinateReferenceSystems;

class PointSqlServerEncoder
extends AbstractSqlServerEncoder {
    PointSqlServerEncoder() {
    }

    @Override
    public <P extends Position, G extends Geometry<P>> SqlServerGeometry encode(G geom) {
        SqlServerGeometry sqlServerGeom = new SqlServerGeometry();
        if (geom.getSRID() > 0) {
            sqlServerGeom.setCoordinateReferenceSystem(geom.getCoordinateReferenceSystem());
        }
        sqlServerGeom.setIsValid();
        if (geom.isEmpty()) {
            sqlServerGeom.setNumberOfPoints(0);
            sqlServerGeom.setNumberOfFigures(0);
            sqlServerGeom.setNumberOfShapes(1);
            sqlServerGeom.setShape(0, new Shape(-1, -1, OpenGisType.POINT));
            return sqlServerGeom;
        }
        sqlServerGeom.setIsSinglePoint();
        sqlServerGeom.setNumberOfPoints(1);
        if (CoordinateReferenceSystems.hasVerticalAxis(geom.getCoordinateReferenceSystem())) {
            sqlServerGeom.setHasZValues();
            sqlServerGeom.allocateZValueArray();
        }
        if (CoordinateReferenceSystems.hasMeasureAxis(geom.getCoordinateReferenceSystem())) {
            sqlServerGeom.setHasMValues();
            sqlServerGeom.allocateMValueArray();
        }
        sqlServerGeom.setCoordinate(0, geom.getPositions());
        return sqlServerGeom;
    }

    @Override
    protected void encode(Geometry<?> geom, int parentIdx, CountingPositionSequenceBuilder<?> coordinates, List<Figure> figures, List<Shape> shapes) {
        if (!(geom instanceof Point)) {
            throw new IllegalArgumentException("Require Point geometry");
        }
        if (geom.isEmpty()) {
            shapes.add(new Shape(parentIdx, -1, OpenGisType.POINT));
            return;
        }
        int pntOffset = coordinates.getNumAdded();
        int figureOffset = figures.size();
        double[] c = new double[coordinates.getCoordinateDimension()];
        coordinates.add(((Position)geom.getPositionN(0)).toArray(c));
        Figure figure = new Figure(FigureAttribute.Stroke, pntOffset);
        figures.add(figure);
        Shape shape = new Shape(parentIdx, figureOffset, OpenGisType.POINT);
        shapes.add(shape);
    }

    @Override
    public boolean accepts(Geometry geom) {
        return geom instanceof Point;
    }
}

