/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.sqlserver;

import java.util.ArrayList;
import org.geolatte.geom.LinearRing;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.codec.db.sqlserver.AbstractSqlServerDecoder;
import org.geolatte.geom.codec.db.sqlserver.IndexRange;
import org.geolatte.geom.codec.db.sqlserver.OpenGisType;
import org.geolatte.geom.codec.db.sqlserver.SqlServerGeometry;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

class PolygonSqlServerDecoder
extends AbstractSqlServerDecoder {
    PolygonSqlServerDecoder() {
    }

    @Override
    protected OpenGisType getOpenGisType() {
        return OpenGisType.POLYGON;
    }

    protected Polygon<?> createNullGeometry(CoordinateReferenceSystem<?> crs) {
        return new Polygon(crs);
    }

    protected Polygon<?> createGeometry(SqlServerGeometry nativeGeom) {
        return this.createGeometry(nativeGeom, 0);
    }

    protected Polygon<?> createGeometry(SqlServerGeometry nativeGeom, int shapeIndex) {
        if (nativeGeom.isEmptyShape(shapeIndex)) {
            return this.createNullGeometry((CoordinateReferenceSystem)nativeGeom.getCoordinateReferenceSystem());
        }
        IndexRange figureRange = nativeGeom.getFiguresForShape(shapeIndex);
        ArrayList rings = new ArrayList(figureRange.length());
        int i = 1;
        for (int figureIdx = figureRange.start; figureIdx < figureRange.end; ++figureIdx) {
            IndexRange pntIndexRange = nativeGeom.getPointsForFigure(figureIdx);
            if (nativeGeom.isFigureInteriorRing(figureIdx)) {
                rings.add(i++, this.toLinearRing(nativeGeom, pntIndexRange));
                continue;
            }
            rings.add(0, this.toLinearRing(nativeGeom, pntIndexRange));
        }
        LinearRing[] ringArr = new LinearRing[rings.size()];
        return new Polygon(rings.toArray(ringArr));
    }

    private LinearRing<?> toLinearRing(SqlServerGeometry nativeGeom, IndexRange range) {
        PositionSequence<?> positionSequence = nativeGeom.coordinateRange(range);
        return new LinearRing(positionSequence, nativeGeom.getCoordinateReferenceSystem());
    }
}

