/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.support;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.geolatte.geom.Geometries;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.support.Holder;
import org.geolatte.geom.codec.support.LinearPositionsListHolder;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

public class PolygonListHolder
extends Holder {
    private final List<LinearPositionsListHolder> spcs = new ArrayList<LinearPositionsListHolder>();

    public void push(LinearPositionsListHolder lph) {
        this.spcs.add(lph);
    }

    @Override
    public boolean isEmpty() {
        return this.spcs.isEmpty();
    }

    @Override
    public int getCoordinateDimension() {
        return this.spcs.stream().mapToInt(Holder::getCoordinateDimension).max().orElse(0);
    }

    @Override
    public <P extends Position> Geometry<P> toGeometry(CoordinateReferenceSystem<P> crs, GeometryType geomType) {
        return this.isEmpty() ? Geometries.mkEmptyMultiPolygon(crs) : Geometries.mkMultiPolygon(this.toPolygons(crs));
    }

    <P extends Position> List<Polygon<P>> toPolygons(CoordinateReferenceSystem<P> crs) {
        return this.spcs.stream().map(lph -> lph.isEmpty() ? Geometries.mkEmptyPolygon(crs) : Geometries.mkPolygon(lph.toLinearRings(crs))).collect(Collectors.toList());
    }
}

