/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.crs.trans;

import org.geolatte.geom.G2D;
import org.geolatte.geom.G3D;
import org.geolatte.geom.Position;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.crs.CoordinateReferenceSystems;
import org.geolatte.geom.crs.CrsId;
import org.geolatte.geom.crs.CrsRegistry;
import org.geolatte.geom.crs.Datum;
import org.geolatte.geom.crs.GeographicCoordinateReferenceSystem;
import org.geolatte.geom.crs.ProjectedCoordinateReferenceSystem;
import org.geolatte.geom.crs.UnsupportedCoordinateReferenceSystem;
import org.geolatte.geom.crs.trans.ConcatenatedOperation;
import org.geolatte.geom.crs.trans.CoordinateOperation;
import org.geolatte.geom.crs.trans.Geographic3DTo2DConversion;
import org.geolatte.geom.crs.trans.GeographicToGeocentricConversion;
import org.geolatte.geom.crs.trans.PositionVectorTransformation;
import org.geolatte.geom.crs.trans.UnsupportedTransformException;
import org.geolatte.geom.crs.trans.projections.Projections;

public class CoordinateOperations {
    public static CoordinateOperation positionVectorTransformation2D(GeographicCoordinateReferenceSystem<G2D> source, GeographicCoordinateReferenceSystem<G2D> target) {
        CoordinateOperation datumTransformation = CoordinateOperations.positionVectorTransformation(source.getDatum(), target.getDatum());
        return new ConcatenatedOperation.Builder().reverse(new Geographic3DTo2DConversion()).forward(new GeographicToGeocentricConversion(source)).forward(datumTransformation).reverse(new GeographicToGeocentricConversion(target)).forward(new Geographic3DTo2DConversion()).build();
    }

    public static CoordinateOperation positionVectorTransformation3D(GeographicCoordinateReferenceSystem<G3D> source, GeographicCoordinateReferenceSystem<G3D> target) {
        CoordinateOperation datumTransformation = CoordinateOperations.positionVectorTransformation(source.getDatum(), target.getDatum());
        return new ConcatenatedOperation.Builder().forward(new GeographicToGeocentricConversion(source)).forward(datumTransformation).reverse(new GeographicToGeocentricConversion(target)).build();
    }

    public static CoordinateOperation positionVectorTransformation(Datum source, Datum target) {
        if (source == target) {
            return new IdentityOp(3);
        }
        if (CoordinateReferenceSystems.WGS84.getDatum().equals(source)) {
            if (target.getToWGS84().length == 0) {
                throw new IllegalArgumentException("Source and target datums must have a ToWGS84 parameters ");
            }
            return PositionVectorTransformation.fromTOWGS84(target.getToWGS84()).reversed();
        }
        if (CoordinateReferenceSystems.WGS84.getDatum().equals(target)) {
            if (source.getToWGS84().length == 0) {
                throw new IllegalArgumentException("Source and target datums must have a ToWGS84 parameters ");
            }
            return PositionVectorTransformation.fromTOWGS84(source.getToWGS84());
        }
        if (source.getToWGS84().length == 0 || target.getToWGS84().length == 0) {
            throw new IllegalArgumentException("Source and target datums must have a ToWGS84 parameters ");
        }
        return PositionVectorTransformation.fromTOWGS84(source.getToWGS84()).appendReverse(PositionVectorTransformation.fromTOWGS84(target.getToWGS84()));
    }

    public static CoordinateOperation transform(CrsId sourceId, CrsId targetId) {
        CoordinateReferenceSystem<?> source = CrsRegistry.getCoordinateReferenceSystem(sourceId, null);
        CoordinateReferenceSystem<?> target = CrsRegistry.getCoordinateReferenceSystem(targetId, null);
        if (source == null) {
            throw new UnsupportedCoordinateReferenceSystem(sourceId);
        }
        if (target == null) {
            throw new UnsupportedCoordinateReferenceSystem(targetId);
        }
        return CoordinateOperations.transform(source, target);
    }

    public static <P extends Position, Q extends Position> CoordinateOperation transform(CoordinateReferenceSystem<P> source, CoordinateReferenceSystem<Q> target) {
        GeographicCoordinateReferenceSystem targetGeodetic;
        GeographicCoordinateReferenceSystem sourceGeodetic;
        if (source == null || target == null) {
            throw new IllegalArgumentException("No null parameters accepted");
        }
        ConcatenatedOperation.Builder builder = new ConcatenatedOperation.Builder();
        if (source instanceof ProjectedCoordinateReferenceSystem) {
            ProjectedCoordinateReferenceSystem projectedSource = (ProjectedCoordinateReferenceSystem)source;
            builder.reverse(Projections.buildFrom(projectedSource));
            sourceGeodetic = projectedSource.getGeographicCoordinateSystem();
        } else if (source instanceof GeographicCoordinateReferenceSystem) {
            sourceGeodetic = (GeographicCoordinateReferenceSystem)source;
        } else {
            throw new UnsupportedTransformException(source.getCrsId(), target.getCrsId());
        }
        if (target instanceof GeographicCoordinateReferenceSystem) {
            targetGeodetic = (GeographicCoordinateReferenceSystem)target;
            if (!sourceGeodetic.equals(targetGeodetic)) {
                builder.forward(CoordinateOperations.positionVectorTransformation2D(sourceGeodetic, targetGeodetic));
            }
        } else if (target instanceof ProjectedCoordinateReferenceSystem) {
            ProjectedCoordinateReferenceSystem projectedTarget = (ProjectedCoordinateReferenceSystem)target;
            targetGeodetic = projectedTarget.getGeographicCoordinateSystem();
            CoordinateOperation forwardOp = Projections.buildFrom(projectedTarget);
            if (!sourceGeodetic.equals(targetGeodetic)) {
                builder.forward(CoordinateOperations.positionVectorTransformation2D(sourceGeodetic, targetGeodetic));
            }
            builder.forward(forwardOp);
        } else {
            throw new UnsupportedTransformException(source.getCrsId(), target.getCrsId());
        }
        return builder.build();
    }

    public static CoordinateOperation identity(int dim) {
        return new IdentityOp(dim);
    }

    private static class IdentityOp
    implements CoordinateOperation {
        private final int dimension;

        IdentityOp(int dimension) {
            this.dimension = dimension;
        }

        @Override
        public boolean isReversible() {
            return true;
        }

        @Override
        public int inCoordinateDimension() {
            return this.dimension;
        }

        @Override
        public int outCoordinateDimension() {
            return this.dimension;
        }

        @Override
        public void forward(double[] inCoordinate, double[] outCoordinate) {
            System.arraycopy(inCoordinate, 0, outCoordinate, 0, this.dimension);
        }

        @Override
        public void reverse(double[] inCoordinate, double[] outCoordinate) {
            this.forward(inCoordinate, outCoordinate);
        }
    }
}

