/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.crs.trans.projections;

import java.util.List;
import java.util.Map;
import org.geolatte.geom.crs.CrsParameter;
import org.geolatte.geom.crs.Ellipsoid;
import org.geolatte.geom.crs.GeographicCoordinateReferenceSystem;
import org.geolatte.geom.crs.trans.CoordinateOperation;
import org.geolatte.geom.crs.trans.WithEpsgGOperationMethod;

public class LambertConformalConic2SP
implements CoordinateOperation,
WithEpsgGOperationMethod {
    private final GeographicCoordinateReferenceSystem baseCrs;
    private final double latOfFO;
    private final double lonOfFO;
    private final double lat1SP;
    private final double lat2SP;
    private final double eastingAtFO;
    private final double northingAtFO;
    private final double ecc;
    private final double a;
    double m1;
    double m2;
    double t1;
    double t2;
    double tF;
    double n;
    double F;
    double rF;

    static LambertConformalConic2SP fromCrsParameters(GeographicCoordinateReferenceSystem baseCrs, List<CrsParameter> params) {
        Map<String, CrsParameter> map = CrsParameter.toMap(params);
        double latitudeOfFO = map.get("latitude_of_origin").getValue();
        double longitudeOfFO = map.get("central_meridian").getValue();
        double lat1SPDeg = map.get("standard_parallel_1").getValue();
        double lat2SPDeg = map.get("standard_parallel_2").getValue();
        double eastingAtFO = map.get("false_easting").getValue();
        double northingAtFO = map.get("false_northing").getValue();
        return new LambertConformalConic2SP(baseCrs, latitudeOfFO, longitudeOfFO, lat1SPDeg, lat2SPDeg, eastingAtFO, northingAtFO);
    }

    public LambertConformalConic2SP(GeographicCoordinateReferenceSystem baseCrs, double latitudeOfFO, double longitudeOfFO, double lat1SPDeg, double lat2SPDeg, double eastingAtFO, double northingAtFO) {
        this.baseCrs = baseCrs;
        this.latOfFO = Math.toRadians(latitudeOfFO);
        this.lonOfFO = Math.toRadians(longitudeOfFO);
        this.lat1SP = Math.toRadians(lat1SPDeg);
        this.lat2SP = Math.toRadians(lat2SPDeg);
        this.eastingAtFO = eastingAtFO;
        this.northingAtFO = northingAtFO;
        Ellipsoid ellipsoid = baseCrs.getDatum().getEllipsoid();
        double invFlat = ellipsoid.getInverseFlattening();
        double flattening = 1.0 / invFlat;
        this.ecc = Math.sqrt(2.0 * flattening - Math.pow(flattening, 2.0));
        this.a = ellipsoid.getSemiMajorAxis();
        this.m1 = Math.cos(this.lat1SP) / Math.sqrt(1.0 - Math.pow(this.ecc, 2.0) * Math.pow(Math.sin(this.lat1SP), 2.0));
        this.m2 = Math.cos(this.lat2SP) / Math.sqrt(1.0 - Math.pow(this.ecc, 2.0) * Math.pow(Math.sin(this.lat2SP), 2.0));
        this.t1 = this.t(this.lat1SP);
        this.t2 = this.t(this.lat2SP);
        this.tF = this.t(this.latOfFO);
        this.n = (Math.log(this.m1) - Math.log(this.m2)) / (Math.log(this.t1) - Math.log(this.t2));
        this.F = this.m1 / (this.n * Math.pow(this.t1, this.n));
        this.rF = this.a * this.F * Math.pow(this.tF, this.n);
    }

    @Override
    public boolean isReversible() {
        return true;
    }

    @Override
    public int inCoordinateDimension() {
        return 2;
    }

    @Override
    public int outCoordinateDimension() {
        return 2;
    }

    private double t(double phi) {
        return Math.tan(0.7853981633974483 - phi / 2.0) / Math.pow((1.0 - this.ecc * Math.sin(phi)) / (1.0 + this.ecc * Math.sin(phi)), this.ecc / 2.0);
    }

    @Override
    public void forward(double[] inCoordinate, double[] outCoordinate) {
        double phi = Math.toRadians(inCoordinate[1]);
        double lambda = Math.toRadians(inCoordinate[0]);
        double tPhi = this.t(phi);
        double r = this.a * this.F * Math.pow(tPhi, this.n);
        double theta = this.n * (lambda - this.lonOfFO);
        outCoordinate[0] = this.eastingAtFO + r * Math.sin(theta);
        outCoordinate[1] = this.northingAtFO + this.rF - r * Math.cos(theta);
    }

    @Override
    public void reverse(double[] inCoordinate, double[] outCoordinate) {
        double phi0;
        double E = inCoordinate[0];
        double N = inCoordinate[1];
        double rNN = this.rF - (N - this.northingAtFO);
        double rPrime = Math.signum(this.n) * Math.sqrt(Math.pow(E - this.eastingAtFO, 2.0) + Math.pow(rNN, 2.0));
        double tPrime = Math.pow(rPrime / (this.a * this.F), 1.0 / this.n);
        double thetaPrime = Math.atan((E - this.eastingAtFO) / rNN);
        double phi = 1.5707963267948966 - 2.0 * Math.atan(tPrime);
        int iters = 0;
        while (Math.abs((phi = 1.5707963267948966 - 2.0 * Math.atan(tPrime * Math.pow((1.0 - this.ecc * Math.sin(phi0 = phi)) / (1.0 + this.ecc * Math.sin(phi0)), this.ecc / 2.0))) - phi0) > 0.001 && ++iters < 5) {
        }
        double lambda = thetaPrime / this.n + this.lonOfFO;
        outCoordinate[0] = Math.toDegrees(lambda);
        outCoordinate[1] = Math.toDegrees(phi);
    }

    @Override
    public int getMethodId() {
        return 9802;
    }
}

